% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runVAM.R
\name{runVAM}
\alias{runVAM}
\title{Run VAM to score gene sets in single cell data}
\usage{
runVAM(
  inSCE,
  geneSetCollectionName = "H",
  useAssay = "logcounts",
  resultNamePrefix = NULL,
  center = FALSE,
  gamma = TRUE
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{geneSetCollectionName}{Character. The name of the gene set collection
to use. Default \code{"H"}.}

\item{useAssay}{Character. The name of the assay to use. This assay should
contain log normalized counts. Default \code{"logcounts"}.}

\item{resultNamePrefix}{Character. Prefix to the name the VAM results which
will be stored in the reducedDim slot of \code{inSCE}. The names of the
output matrices will be \code{resultNamePrefix_Distance} and
\code{resultNamePrefix_CDF}. If this parameter is set to \code{NULL}, then
\code{"VAM_geneSetCollectionName_"} will be used. Default \code{NULL}.}

\item{center}{Boolean. If \code{TRUE}, values will be mean centered when
computing the Mahalanobis statistic. Default \code{FALSE}.}

\item{gamma}{Boolean. If \code{TRUE}, a gamma distribution will be fit to
the non-zero squared Mahalanobis distances computed from a row-permuted
version of the gene expression matrix. The estimated gamma distribution will
be used to compute a one-sided p-value for each cell. If \code{FALSE}, the
p-value will be computed using the standard chi-square approximation for the
squared Mahalanobis distance (or non-central if \code{center = FALSE}).
Default \code{TRUE}.}
}
\value{
A \linkS4class{SingleCellExperiment} object with VAM metrics stored
in \code{reducedDim} as \code{VAM_NameOfTheGeneset_Distance} and
\code{VAM_NameOfTheGeneset_CDF}.
}
\description{
Wrapper for the Variance-adjusted Mahalanobis (VAM), which is a
fast and accurate method for cell-specific gene set scoring of single cell
data. This algorithm computes distance statistics and one-sided p-values for
all cells in the specified single cell gene expression matrix. Gene sets
should already be imported and stored in the meta data using functions such
as \link{importGeneSetsFromList} or \link{importGeneSetsFromMSigDB}
}
\examples{
data(scExample, package = "singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
sce <- scaterlogNormCounts(sce, assayName = "logcounts")
gs1 <- rownames(sce)[seq(10)]
gs2 <- rownames(sce)[seq(11,20)]
gs <- list("geneset1" = gs1, "geneset2" = gs2)
sce <- importGeneSetsFromList(inSCE = sce,geneSetList = gs,
                              by = "rownames")
sce <- runVAM(inSCE = sce,
              geneSetCollectionName = "GeneSetCollection",
              useAssay = "logcounts")
}
\seealso{
\link{importGeneSetsFromList}, \link{importGeneSetsFromMSigDB},
\link{importGeneSetsFromGMT}, \link{importGeneSetsFromCollection} for
importing gene sets. \link{sctkListGeneSetCollections},
\link{getPathwayResultNames} and \link{getGenesetNamesFromCollection} for
available related information in \code{inSCE}.
}
\author{
Nida Pervaiz
}
