% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runTSCAN.R
\name{runTSCAN}
\alias{runTSCAN}
\title{Run TSCAN to obtain pseudotime values for cells}
\usage{
runTSCAN(
  inSCE,
  useReducedDim = "PCA",
  cluster = NULL,
  starter = NULL,
  seed = 12345
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{useReducedDim}{Character. A low-dimension representation in
\code{reducedDims}, will be used for both clustering if \code{cluster} not
specified and MST construction. Default \code{"PCA"}.}

\item{cluster}{Grouping for each cell in \code{inSCE}. A vector with equal
length to the number of the cells in \code{inSCE}, or a single character for
retriving \code{colData} variable. Default \code{NULL}, will run
\code{runScranSNN} to obtain.}

\item{starter}{Character. Specifies the starting node from which to compute
the pseudotime. Default \code{NULL}, will select an arbitrary node.}

\item{seed}{An integer. Random seed for clustering if \code{cluster} is not
specified. Default \code{12345}.}
}
\value{
The input \code{inSCE} object with pseudotime ordering of the cells
along the paths and the cluster label stored in \code{colData}, and other
unstructured information in \code{metadata}.
}
\description{
Wrapper for obtaining a pseudotime ordering of the cells by
projecting them onto the minimum spanning tree (MST)
}
\examples{
data("mouseBrainSubsetSCE", package = "singleCellTK")
mouseBrainSubsetSCE <- runTSCAN(inSCE = mouseBrainSubsetSCE,
                                useReducedDim = "PCA_logcounts")
}
\author{
Nida Pervaiz
}
