% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runBatchCorrection.R
\name{runLimmaBC}
\alias{runLimmaBC}
\title{Apply Limma's batch effect correction method to SingleCellExperiment object}
\usage{
runLimmaBC(inSCE, useAssay = "logcounts", assayName = "LIMMA", batch = "batch")
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object}

\item{useAssay}{A single character indicating the name of the assay requiring
batch correction. Default \code{"logcounts"}.}

\item{assayName}{A single characeter. The name for the corrected assay. Will
be saved to \code{\link{assay}}. Default
\code{"LIMMA"}.}

\item{batch}{A single character indicating a field in \code{colData} that
annotates the batches of each cell; or a vector/factor with the same length
as the number of cells. Default \code{"batch"}.}
}
\value{
The input \linkS4class{SingleCellExperiment} object with
\code{assay(inSCE, assayName)} updated.
}
\description{
Limma's batch effect removal function fits a linear model to the data, then
removes the component due to the batch effects.
}
\examples{
data('sceBatches', package = 'singleCellTK')
logcounts(sceBatches) <- log1p(counts(sceBatches))
sceCorr <- runLimmaBC(sceBatches)
}
\references{
Gordon K Smyth, et al., 2003
}
