% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runSoupX.R
\name{getSoupX<-}
\alias{getSoupX<-}
\alias{getSoupX}
\alias{getSoupX,SingleCellExperiment-method}
\alias{getSoupX<-,SingleCellExperiment-method}
\title{Get or Set SoupX Result}
\usage{
getSoupX(inSCE, sampleID, background = FALSE) <- value

getSoupX(inSCE, sampleID = NULL, background = FALSE)

\S4method{getSoupX}{SingleCellExperiment}(inSCE, sampleID = NULL, background = FALSE)

\S4method{getSoupX}{SingleCellExperiment}(inSCE, sampleID, background = FALSE) <- value
}
\arguments{
\item{inSCE}{A \linkS4class{SingleCellExperiment} object. For getter method,
\code{\link{runSoupX}} must have been already applied.}

\item{sampleID}{Character vector. For getter method, the samples that should
be included in the returned list. Leave this \code{NULL} for all samples.
Default \code{NULL}. For setter method, only one sample allowed.}

\item{background}{Logical. Whether \code{background} was applied when
running \code{\link{runSoupX}}. Default \code{FALSE}.}

\item{value}{Dedicated list object of SoupX results.}
}
\value{
For getter method, a list with SoupX results for specified samples.
For setter method, \code{inSCE} with SoupX results updated.

For getter method, a list with SoupX results for specified samples.
For setter method, \code{inSCE} with SoupX results updated.
}
\description{
S4 method for getting and setting SoupX results that cannot be
appended to either \code{rowData(inSCE)} or \code{colData(inSCE)}.

S4 method for getting and setting SoupX results that cannot be
appended to either \code{rowData(inSCE)} or \code{colData(inSCE)}.
}
\examples{
\dontrun{
sce <- importExampleData("pbmc3k")
sce <- runSoupX(sce, sample = "sample")
soupXResults <- getSoupX(sce)
}
}
\seealso{
runSoupX, plotSoupXResults
}
