% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keywords.R
\name{keyword_enrichment_from_GO}
\alias{keyword_enrichment_from_GO}
\title{Keyword enrichment for GO terms}
\usage{
keyword_enrichment_from_GO(go_id, min_bg = 5, min_term = 2)
}
\arguments{
\item{go_id}{A vector of GO IDs.}

\item{min_bg}{Minimal number of GO terms (in the background, i.e. all GO temrs in the GO database) that contain a specific keyword.}

\item{min_term}{Minimal number of GO terms (GO terms in \code{go_id}) that contain a specific keyword.}
}
\value{
A data frame with keyword enrichment results.
}
\description{
Keyword enrichment for GO terms
}
\details{
The enrichment is applied by Fisher's exact test. For a keyword, there is the following 2x2 contigency table:

\if{html}{\out{<div class="sourceCode">}}\preformatted{                      | contains the keyword | does not contain the keyword
    In the GO set     |          s11         |          s12
    Not in the GO set |          s21         |          s22
}\if{html}{\out{</div>}}

where \code{s11}, \code{s12}, \code{s21} and \code{s22} are the counts of GO terms in the four categories.
}
\examples{
\donttest{
go_id = random_GO(100)
keyword_enrichment_from_GO(go_id)
}
}
