% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{export_to_shiny_app}
\alias{export_to_shiny_app}
\title{Interactively visualize the similarity heatmap}
\usage{
export_to_shiny_app(mat, cl = binary_cut(mat))
}
\arguments{
\item{mat}{A similarity matrix.}

\item{cl}{Cluster labels inferred from the similarity matrix, e.g. from \code{\link[=cluster_terms]{cluster_terms()}} or \code{\link[=binary_cut]{binary_cut()}}.}
}
\value{
A shiny application.
}
\description{
Interactively visualize the similarity heatmap
}
\examples{
if(interactive()) {
    mat = readRDS(system.file("extdata", "random_GO_BP_sim_mat.rds", 
        package = "simplifyEnrichment"))
    cl = binary_cut(mat)
    export_to_shiny_app(mat, cl)
}
}
