% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z.register_methods.R
\name{register_clustering_methods}
\alias{register_clustering_methods}
\alias{all_clustering_methods}
\alias{remove_clustering_methods}
\alias{reset_clustering_methods}
\title{Configure clustering methods}
\usage{
register_clustering_methods(...)

all_clustering_methods()

remove_clustering_methods(method)

reset_clustering_methods()
}
\arguments{
\item{...}{A named list of clustering functions, see in \strong{Details}.}

\item{method}{A vector of method names.}
}
\value{
\code{all_clustering_methods()} returns a vector of clustering method names.
}
\description{
Configure clustering methods
}
\details{
The user-defined functions should accept at least one argument which is the input matrix.
The second optional argument should always be \code{...} so that parameters
for the clustering function can be passed by the \code{control} argument from \code{\link[=cluster_terms]{cluster_terms()}}, \code{\link[=simplifyGO]{simplifyGO()}} or \code{\link[=simplifyEnrichment]{simplifyEnrichment()}}.
If users forget to add \code{...}, it is added internally.

Please note, the user-defined function should automatically identify the optimized
number of clusters.

The function should return a vector of cluster labels. Internally it is converted to numeric labels.

The default clustering methods are:
\itemize{
\item \code{kmeans} see \code{\link[=cluster_by_kmeans]{cluster_by_kmeans()}}.
\item \code{dynamicTreeCut} see \code{\link[=cluster_by_dynamicTreeCut]{cluster_by_dynamicTreeCut()}}.
\item \code{mclust} see \code{\link[=cluster_by_mclust]{cluster_by_mclust()}}.
\item \code{apcluster} see \code{\link[=cluster_by_apcluster]{cluster_by_apcluster()}}.
\item \code{hdbscan} see \code{\link[=cluster_by_hdbscan]{cluster_by_hdbscan()}}.
\item \code{fast_greedy} see \code{\link[=cluster_by_fast_greedy]{cluster_by_fast_greedy()}}.
\item \code{louvain} see \code{\link[=cluster_by_louvain]{cluster_by_louvain()}}.
\item \code{walktrap} see \code{\link[=cluster_by_walktrap]{cluster_by_walktrap()}}.
\item \code{MCL} see \code{\link[=cluster_by_MCL]{cluster_by_MCL()}}.
\item \code{binary_cut} see \code{\link[=binary_cut]{binary_cut()}}.
}
}
\examples{
register_clustering_methods(
    # assume there are 5 groups
    random = function(mat, ...) sample(5, nrow(mat), replace = TRUE)
)
all_clustering_methods()
remove_clustering_methods("random")
all_clustering_methods()
remove_clustering_methods(c("kmeans", "mclust"))
all_clustering_methods()
reset_clustering_methods()
all_clustering_methods()
}
