% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity_GO.R
\name{GO_similarity}
\alias{GO_similarity}
\alias{guess_ont}
\alias{random_GO}
\title{Calculate Gene Ontology (GO) semantic similarity matrix}
\usage{
GO_similarity(
  go_id,
  ont = NULL,
  db = "org.Hs.eg.db",
  measure = "Sim_XGraSM_2013"
)

guess_ont(go_id, db = "org.Hs.eg.db")

random_GO(n, ont = c("BP", "CC", "MF"), db = "org.Hs.eg.db")
}
\arguments{
\item{go_id}{A vector of GO IDs.}

\item{ont}{Sub-ontology of GO. Value should be one of "BP", "CC" or "MF". If it is not specified,
the function automatically identifies it by random sampling 10 IDs from \code{go_id} (see \code{guess_ont()}).}

\item{db}{Annotation database. It should be an OrgDb package name from \url{https://bioconductor.org/packages/release/BiocViews.html#___OrgDb}. The value
can also directly be an \code{OrgDb} object.}

\item{measure}{Semantic measure for the GO similarity, pass to \code{\link[simona:term_sim]{simona::term_sim()}}. All valid values are in \code{\link[simona:all_methods]{simona::all_term_sim_methods()}}.}

\item{n}{Number of GO IDs.}
}
\value{
\code{GO_similarity()} returns a symmetric matrix.

\code{guess_ont()} returns a single character scalar of "BP", "CC" or "MF".
If there are more than one ontologies detected. It returns \code{NULL}.

\code{random_GO()} returns a vector of GO IDs.
}
\description{
Calculate Gene Ontology (GO) semantic similarity matrix
}
\details{
The default similarity method is "Sim_XGraSM_2013". Since the semantic similarities are calculated based on gene annotations to GO terms,
I suggest users also try the following methods:
\itemize{
\item \code{"Sim_Lin_1998"}
\item \code{"Sim_Resnik_1999"}
\item \code{"Sim_Relevance_2006"}
\item \code{"Sim_SimIC_2010"}
\item \code{"Sim_XGraSM_2013"}
\item \code{"Sim_EISI_2015"}
\item \code{"Sim_AIC_2014"}
\item \code{"Sim_Wang_2007"}
\item \code{"Sim_GOGO_2018"}
}

In \code{guess_ont()}, only 10 random GO IDs are checked.

In \code{random_GO()}, only GO terms with gene annotations are sampled.
}
\examples{
\donttest{
go_id = random_GO(100)
mat = GO_similarity(go_id)
}
\donttest{
go_id = random_GO(100)
guess_ont(go_id)
}
}
