% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anno_gene.R
\name{ontology_kw}
\alias{ontology_kw}
\alias{ontology_chebi}
\alias{ontology_hp}
\alias{ontology_pw}
\alias{ontology_rdo}
\alias{ontology_vt}
\alias{ontology_go}
\alias{ontology_reactome}
\title{Import ontologies already having gene annotations}
\usage{
ontology_kw(
  organism = "human",
  gene_annotation = TRUE,
  verbose = simona_opt$verbose,
  ...
)

ontology_chebi(
  organism = c("human", "mouse", "rat", "pig", "dog"),
  gene_annotation = TRUE,
  verbose = simona_opt$verbose,
  ...
)

ontology_hp(
  organism = c("human", "mouse"),
  gene_annotation = TRUE,
  verbose = simona_opt$verbose,
  ...
)

ontology_pw(
  organism = c("human", "mouse", "rat", "pig", "dog", "chimpanzee"),
  gene_annotation = TRUE,
  verbose = simona_opt$verbose,
  ...
)

ontology_rdo(
  organism = c("human", "mouse", "rat", "pig", "dog", "chimpanzee"),
  gene_annotation = TRUE,
  verbose = simona_opt$verbose,
  ...
)

ontology_vt(
  organism = c("human", "mouse", "rat", "pig", "dog", "chimpanzee"),
  gene_annotation = TRUE,
  verbose = simona_opt$verbose,
  ...
)

ontology_go(...)

ontology_reactome(
  organism = "HSA",
  gene_annotation = TRUE,
  verbose = simona_opt$verbose,
  ...
)
}
\arguments{
\item{organism}{Organism.}

\item{gene_annotation}{Whether to add gene annotations to the DAG.}

\item{verbose}{Whether to print messages?}

\item{...}{Pass to \code{\link[=create_ontology_DAG]{create_ontology_DAG()}}.}
}
\description{
Import ontologies already having gene annotations
}
\details{
There are the following ontologies:
\itemize{
\item \code{ontology_kw()}: UniProt Keywords. The list of supported organisms can be found in \code{\link[UniProtKeywords:load_keyword_genesets]{UniProtKeywords::load_keyword_genesets()}}.
\item \code{ontology_chebi()}: Chemical Entities of Biological Interest.
\item \code{ontology_hp()}: The Human Phenotype Ontology.
\item \code{ontology_pw()}: Pathway Ontology.
\item \code{ontology_rdo()}: RGD Disease Ontology.
\item \code{ontology_vt()}: Vertebrate Trait Ontology.
}

The source of the original files can be found with \code{simona:::RGD_TB}.

\code{ontology_go()} is an alias of \code{\link[=create_ontology_DAG_from_GO_db]{create_ontology_DAG_from_GO_db()}}. All arguments go there.

Valid values for \code{organism} argument in \code{ontology_reactome()} are

\if{html}{\out{<div class="sourceCode">}}\preformatted{c("BTA", "CEL", "CFA", "DRE", "DDI", "DME", "GGA", "HSA", "MMU", 
  "MTU", "PFA", "RNO", "SCE", "SPO", "SSC", "XTR")
}\if{html}{\out{</div>}}
}
