% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{term_annotations}
\alias{term_annotations}
\alias{annotated_terms}
\title{Term-item associations}
\usage{
term_annotations(dag, terms, return = "list")

annotated_terms(dag, anno, return = "list")
}
\arguments{
\item{dag}{An \code{ontology_DAG} object.}

\item{terms}{A vector of term names.}

\item{return}{Whether the returned object is a list or a matrix?}

\item{anno}{A vector of annotated item names.}
}
\value{
A list or a binary matrix showing annotation relations between terms and items.
}
\description{
Term-item associations
}
\details{
If an item is annotated to a term, all this term's ancestor terms are also annotated.
}
\examples{
parents  = c("a", "a", "b", "b", "c", "d")
children = c("b", "c", "c", "d", "e", "f")
annotation = list(
    "a" = c("t1", "t2", "t3"),
    "b" = c("t3", "t4"),
    "c" = "t5",
    "d" = "t7",
    "e" = c("t4", "t5", "t6", "t7"),
    "f" = "t8"
)
dag = create_ontology_DAG(parents, children, annotation = annotation)
term_annotations(dag, letters[1:6])
term_annotations(dag, letters[1:6], return = "matrix")
annotated_terms(dag, c("t1", "t2", "t3"))
annotated_terms(dag, c("t1", "t2", "t3"), return = "matrix")
}
