% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{imputeBetas}
\alias{imputeBetas}
\title{Impute of missing data of specific platform}
\usage{
imputeBetas(
  betas,
  platform = NULL,
  BPPARAM = SerialParam(),
  celltype = NULL,
  sd_max = 999
)
}
\arguments{
\item{betas}{named vector of beta values}

\item{platform}{platform}

\item{BPPARAM}{use MulticoreParam(n) for parallel processing}

\item{celltype}{celltype/tissue context of imputation, if not given, will
use nearest neighbor to determine.}

\item{sd_max}{maximum standard deviation in imputation confidence}
}
\value{
imputed data, vector or matrix
}
\description{
Impute of missing data of specific platform
}
\examples{
betas = openSesame(sesameDataGet("EPIC.1.SigDF"))
sum(is.na(betas))
betas2 = imputeBetas(betas, "EPIC")
sum(is.na(betas2))

}
