% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numDetectedAcrossCells.R
\name{numDetectedAcrossCells}
\alias{numDetectedAcrossCells}
\alias{numDetectedAcrossCells,ANY-method}
\alias{numDetectedAcrossCells,SummarizedExperiment-method}
\title{Number of detected expression values per group of cells}
\usage{
numDetectedAcrossCells(x, ...)

\S4method{numDetectedAcrossCells}{ANY}(
  x,
  ids,
  subset.row = NULL,
  subset.col = NULL,
  store.number = "ncells",
  average = FALSE,
  threshold = 0,
  BPPARAM = SerialParam(),
  subset_row = NULL,
  subset_col = NULL,
  store_number = NULL,
  detection_limit = NULL
)

\S4method{numDetectedAcrossCells}{SummarizedExperiment}(x, ..., assay.type = "counts", exprs_values = NULL)
}
\arguments{
\item{x}{A numeric matrix of counts containing features in rows and cells in columns.
Alternatively, a \linkS4class{SummarizedExperiment} object containing such a count matrix.}

\item{...}{For the generic, further arguments to pass to specific methods.

For the SummarizedExperiment method, further arguments to pass to the ANY method.}

\item{ids}{A factor specifying the group to which each cell in \code{x} belongs.
Alternatively, a \linkS4class{DataFrame} of such vectors or factors, 
in which case each unique combination of levels defines a group.}

\item{subset.row}{An integer, logical or character vector specifying the features to use.
If \code{NULL}, defaults to all features.
For the \linkS4class{SingleCellExperiment} method, this argument will not affect alternative Experiments,
where aggregation is always performed for all features (or not at all, depending on \code{use_alt_exps}).}

\item{subset.col}{An integer, logical or character vector specifying the cells to use.
Defaults to all cells with non-\code{NA} entries of \code{ids}.}

\item{store.number}{String specifying the field of the output \code{\link{colData}} to store the number of cells in each group.
If \code{NULL}, nothing is stored.}

\item{average}{Logical scalar indicating whether the proportion of non-zero counts in each group should be computed instead.}

\item{threshold}{A numeric scalar specifying the threshold above which a gene is considered to be detected.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying whether summation should be parallelized.}

\item{subset_row, subset_col, detection_limit, store_number, exprs_values}{Soft-deprecated equivalents of the arguments above.}

\item{assay.type}{A string or integer scalar specifying the assay of \code{x} containing the matrix of counts
(or any other expression quantity that can be meaningfully summed).}
}
\value{
A SummarizedExperiment is returned containing a count matrix in the first assay.
Each column corresponds to group as defined by a unique level or combination of levels in \code{ids}.
Each entry of the matrix contains the number of cells with detected expression for a feature and group.
The identities of the levels for each column are reported in the \code{\link{colData}}.
If \code{average=TRUE}, the assay is instead a numeric matrix containing the proportion of detected values.
}
\description{
Computes the number of detected expression values (by default, defined as non-zero counts) 
for each feature in each group of cells.
This function is deprecated: use \code{\link{summarizeAssayByGroup}} instead.
}
\examples{
example_sce <- mockSCE()

ids <- sample(LETTERS[1:5], ncol(example_sce), replace=TRUE)
bycol <- numDetectedAcrossCells(example_sce, ids)
head(bycol)

}
\seealso{
\code{\link{sumCountsAcrossCells}}, which computes the sum of counts within a group.
}
\author{
Aaron Lun
}
