% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonalScatter.R
\name{clonalScatter}
\alias{clonalScatter}
\title{Scatter Plot Comparing Clones Across Two Samples}
\usage{
clonalScatter(
  input.data,
  cloneCall = "strict",
  x.axis = NULL,
  y.axis = NULL,
  chain = "both",
  dot.size = "total",
  group.by = NULL,
  graph = "proportion",
  exportTable = FALSE,
  palette = "inferno",
  ...
)
}
\arguments{
\item{input.data}{The product of \code{\link[=combineTCR]{combineTCR()}},
\code{\link[=combineBCR]{combineBCR()}}, or \code{\link[=combineExpression]{combineExpression()}}.}

\item{cloneCall}{Defines the clonal sequence grouping. Accepted values
are: \code{gene} (VDJC genes), \code{nt} (CDR3 nucleotide sequence), \code{aa} (CDR3 amino
acid sequence), or \code{strict} (VDJC + nt). A custom column header can also be used.}

\item{x.axis}{name of the list element to appear on the x.axis.}

\item{y.axis}{name of the list element to appear on the y.axis.}

\item{chain}{The TCR/BCR chain to use. Use \code{both} to include both chains
(e.g., TRA/TRB). Accepted values: \code{TRA}, \code{TRB}, \code{TRG}, \code{TRD}, \code{IGH}, \code{IGL}
(for both light chains), \code{both}.}

\item{dot.size}{either total or the name of the list element to
use for size of dots.}

\item{group.by}{A column header in the metadata or lists to group the analysis
by (e.g., "sample", "treatment"). If \code{NULL}, data will be analyzed
by list element or active identity in the case of single-cell objects.}

\item{graph}{graph either the clonal "proportion" or "count".}

\item{exportTable}{If \code{TRUE}, returns a data frame or matrix of the results
instead of a plot.}

\item{palette}{Colors to use in visualization - input any
\link[grDevices:palettes]{hcl.pals}.}

\item{...}{Additional arguments passed to the ggplot theme}
}
\value{
A ggplot object visualizing clonal dynamics between two groupings or
a data.frame if \code{exportTable = TRUE}.
}
\description{
This function produces a scatter plot directly comparing
the specific clones between two samples. The clones will
be categorized by counts into singlets or expanded, either
exclusive or shared between the selected samples.
}
\examples{
#Making combined contig data
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))

# Using clonalScatter()
clonalScatter(combined, 
              x.axis = "P17B", 
              y.axis = "P17L",
              graph = "proportion")

}
\concept{Visualizing_Clones}
