% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonalCompare.R
\name{clonalCompare}
\alias{clonalCompare}
\title{Compare Clonal Abundance Across Variables}
\usage{
clonalCompare(
  input.data,
  cloneCall = "strict",
  chain = "both",
  samples = NULL,
  clones = NULL,
  top.clones = NULL,
  highlight.clones = NULL,
  relabel.clones = FALSE,
  group.by = NULL,
  order.by = NULL,
  graph = "alluvial",
  proportion = TRUE,
  exportTable = FALSE,
  palette = "inferno",
  ...
)
}
\arguments{
\item{input.data}{The product of \code{\link{combineTCR}},
\code{\link{combineBCR}}, or \code{\link{combineExpression}}.}

\item{cloneCall}{Defines the clonal sequence grouping. Accepted values
are: \code{gene} (VDJC genes), \code{nt} (CDR3 nucleotide sequence), \code{aa} (CDR3 amino
acid sequence), or \code{strict} (VDJC + nt). A custom column header can also be used.}

\item{chain}{The TCR/BCR chain to use. Use \code{both} to include both chains
(e.g., TRA/TRB). Accepted values: \code{TRA}, \code{TRB}, \code{TRG}, \code{TRD}, \code{IGH}, \code{IGL}
(for both light chains), \code{both}.}

\item{samples}{The specific samples to isolate for visualization.}

\item{clones}{The specific clonal sequences of interest}

\item{top.clones}{The top number of clonal sequences per group.
(e.g., top.clones = 5)}

\item{highlight.clones}{Clonal sequences to highlight, if present,
all other clones returned will be grey}

\item{relabel.clones}{Simplify the legend of the graph by returning
clones that are numerically indexed}

\item{group.by}{A column header in the metadata or lists to group the analysis
by (e.g., "sample", "treatment"). If \code{NULL}, data will be analyzed
by list element or active identity in the case of single-cell objects.}

\item{order.by}{A character vector defining the desired order of elements
of the \code{group.by} variable. Alternatively, use \code{alphanumeric} to sort groups
automatically.}

\item{graph}{The type of plot to generate. Accepted values are \code{alluvial}
(default) or \code{area}}

\item{proportion}{If \code{TRUE} (default), the y-axis will represent the
proportional abundance of clones. If \code{FALSE}, the y-axis will represent
raw clone counts.`}

\item{exportTable}{If \code{TRUE}, returns a data frame or matrix of the results
instead of a plot.}

\item{palette}{Colors to use in visualization - input any
\link[grDevices]{hcl.pals}}

\item{...}{Additional arguments passed to the ggplot theme}
}
\value{
A ggplot object visualizing proportions of clones by groupings, or a
data.frame if \code{exportTable = TRUE}.
}
\description{
This function visualizes the relative abundance of specific clones across
different samples or groups. It is useful for tracking how the proportions
of top clones change between conditions. The output can be an alluvial plot
to trace clonal dynamics or an area plot to show compositional changes.
}
\examples{
# Making combined contig data
combined <- combineTCR(contig_list,
                       samples = c("P17B", "P17L", "P18B", "P18L",
                                   "P19B","P19L", "P20B", "P20L"))

# Using clonalCompares()
clonalCompare(combined,
              top.clones = 5,
              samples = c("P17B", "P17L"),
              cloneCall="aa")

}
\concept{Visualizing_Clones}
