% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poissonModel-utils.R
\name{poissonModel}
\alias{poissonModel}
\title{Poisson model fitting the gene expression matrix and genotype matrix.}
\usage{
poissonModel(
  eQTLObject,
  geneIDs,
  snpIDs,
  biClassify = FALSE,
  pAdjustMethod = "bonferroni",
  pAdjustThreshold = 0.05,
  logfcThreshold = 0.1
)
}
\arguments{
\item{eQTLObject}{An S4 object of class \code{eQTLObject}.}

\item{geneIDs}{Character vector of gene IDs to include in the model fitting.}

\item{snpIDs}{Character vector of SNP IDs to include in the model fitting.}

\item{biClassify}{Logical; whether to convert genotype encoding in snpMatrix
to 0, 1, and 2. \code{TRUE} indicates conversion; \code{FALSE} indicates no
conversion (default).}

\item{pAdjustMethod}{Method used for multiple testing correction. One of
\code{"bonferroni"}, \code{"holm"}, \code{"hochberg"}, \code{"hommel"}, or
\code{"BH"}. Default is \code{"bonferroni"}.}

\item{pAdjustThreshold}{Only SNP–gene pairs with adjusted p-values below
the threshold will be retained. Default is 0.05.}

\item{logfcThreshold}{The minimum beta coefficient (effect size) required
to report a SNP–gene pair as an eQTL.}
}
\value{
A data frame of gene–SNP pairs that pass the filtering criteria,
including beta coefficients, p-values, adjusted p-values, and group labels.
}
\description{
Poisson model fitting the gene expression matrix and genotype matrix.
}
\examples{
data(EQTL_obj)
Gene <- rownames(slot(EQTL_obj, "filterData")$expMat)
SNP <- rownames(slot(EQTL_obj, "filterData")$snpMat)
poissonResult <- poissonModel(
  eQTLObject = EQTL_obj,
  geneIDs = Gene,
  snpIDs = SNP,
  biClassify = FALSE,
  pAdjustMethod = "bonferroni",
  pAdjustThreshold = 0.05,
  logfcThreshold = 0.025
)
}
