% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createGeneLoc-callQTL.R
\name{createGeneLoc}
\alias{createGeneLoc}
\title{Create a gene location data frame.}
\usage{
createGeneLoc(
  geneList,
  gene_mart = NULL,
  geneDataset = "hsapiens_gene_ensembl",
  OrgDb
)
}
\arguments{
\item{geneList}{A gene ID or a list of genes IDs.}

\item{gene_mart}{An object of class Mart representing the BioMart gene
database to connect to. If provided, this should be a Mart object obtained
by calling \code{useEnsembl()}, which allows specifying a mirror in case of
connection issues. If \code{NULL}, the function will create and use a Mart
object pointing to the Ensembl Gene BioMart, using the specified
\code{geneDataset} and a default mirror.}

\item{geneDataset}{A character string specifying the gene dataset to use
from Ensembl. Default is \code{hsapiens_gene_ensembl} for human genes.}

\item{OrgDb}{The name of the OrgDb package to use for gene annotation.
Supported values include \code{org.Hs.eg.db} and \code{org.Mm.eg.db}.}
}
\value{
A \code{data.frame} containing gene location information.
}
\description{
Create a gene location data frame.
}
\examples{
data(GeneData)
geneList <- rownames(GeneData)
library(GOSemSim)
library(biomaRt)
OrgDb <- load_OrgDb("org.Hs.eg.db")
gene_mart <- useEnsembl(biomart = "genes",
                        dataset = "hsapiens_gene_ensembl",
                        mirror = 'asia')
gene_loc <- createGeneLoc(geneList = geneList,
                          gene_mart = gene_mart,
                          OrgDb = OrgDb)
}
