% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arango.R
\name{arango}
\alias{arango}
\alias{arango_request}
\alias{arango_auth}
\alias{arango_collections}
\alias{arango_cursor}
\title{Internal interface to ArangoDB REST API}
\usage{
arango_request(path, ..., body = NULL, jwt_token = NULL)

arango_auth(
  username = rigvf_config$get("username"),
  password = rigvf_config$get("password")
)

arango_collections(
  username = rigvf_config$get("username"),
  password = rigvf_config$get("password")
)

arango_cursor(
  query,
  ...,
  username = rigvf_config$get("username"),
  password = rigvf_config$get("password")
)
}
\arguments{
\item{path}{character(1) path to the API end point. Note that
database-specfic paths are prefixed with \verb{/_db/igvf}.}

\item{...}{for \code{arango_request()}, named arguments to be used a
query parameters. for \code{arango_cursor()}, named arguments to be
interpreted as bind variables in the query.}

\item{body}{if not NULL, formulate a POST request with JSON body.}

\item{jwt_token}{character(1) JWT token obtained via
\code{arango_auth()}.}

\item{username}{character(1) ArangoDB user name. Default: "guest".}

\item{password}{character(1) ArangoDB password. Default:
"guestigvfcatalog". A better practice is to use an environment
variable to record the password, rather than encoding in a
script, so \code{password = Sys.getenv("RIGVF_ARANGODB_PASSWORD")}.}

\item{query}{character(1) the FILE NAME (without extension \code{.aql}
of the query template.}
}
\value{
\code{arango_request()} returns the JSON response as a
character(1) vector.

\code{arango_auth()} returns a JWT token to be used for
authentication in subsequent calls.

\code{arango_collections()} returns a tibble with columns
\code{name}, \code{type} (either 'node' or 'edge'), and \code{count}.

\code{arango_cursor()} returns the JSON character(1) 'result' of
the query.
}
\description{
Objects documented on this page are for developer
use. \code{arango_request()} formulates 'GET' or 'POST' to the ArangoDB
API.

\code{arango_auth()} uses username and password to
authenticate against the database.

\code{arango_collections()} implements the \verb{_api/collection}
endpoint for available collections in the IGVF database.

\code{arango_cursor()} implements the \verb{_api/cursor}
endpoint to allow a user-specified query of the IGVF database.
}
\details{
\code{arango_auth()} is 'memoized', so invoked only once per
hour for a particular user and password. The memoised result
can be cleared with \code{memoise::forget(arango_auth)}.

\code{arango_cursor()} expects queries to be written in package system
files in the \code{inst/aql} directory. This allows rapid iteration
during query development (the package does not need to re-loaded
when the query is updated) and some opportunity for
language-specific highlighting if supported by the developer's text
editor.
}
\examples{
## available queries
templates <- system.file(package = "rigvf", "aql")
dir(templates)
}
