% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{testSurvival}
\alias{testSurvival}
\title{Test the survival difference between groups of subjects}
\usage{
testSurvival(survTerms, ...)
}
\arguments{
\item{survTerms}{\code{survTerms} object: survival terms obtained after
running \code{processSurvTerms} (see examples)}

\item{...}{
  Arguments passed on to \code{\link[survival:survdiff]{survival::survdiff}}
  \describe{
    \item{\code{subset}}{
expression indicating which subset of the rows of data should be used in
the fit.  This can be a logical vector (which is replicated to have
length equal to the number of observations), a numeric vector indicating
which observation numbers are to be included (or excluded if negative),
or a character vector of row names to be included.  All observations are
included by default.
}
    \item{\code{na.action}}{
a missing-data filter function.  This is applied to the \code{model.frame} after any
subset argument has been used.  Default is \code{options()$na.action}.
}
    \item{\code{rho}}{
a scalar parameter that controls the type of test.
}
    \item{\code{timefix}}{process times through the \code{aeqSurv} function to
  eliminate potential roundoff issues.}
  }}
}
\value{
p-value of the survival difference or \code{NA}
}
\description{
Test the survival difference between groups of subjects
}
\note{
Instead of raising errors, returns \code{NA}
}
\examples{
require("survival")
data <- aml
timeStart  <- "event"
event      <- "event"
followup   <- "time"
data$event <- NA
data$event[aml$status == 1] <- aml$time[aml$status == 1]
censoring  <- "right"
formulaStr <- "x"
survTerms <- processSurvTerms(data, censoring=censoring, event=event,
                              timeStart=timeStart, followup=followup,
                              formulaStr=formulaStr)
testSurvival(survTerms)
}
\seealso{
Other functions to analyse survival: 
\code{\link{assignValuePerSubject}()},
\code{\link{getAttributesTime}()},
\code{\link{labelBasedOnCutoff}()},
\code{\link{optimalSurvivalCutoff}()},
\code{\link{plotSurvivalCurves}()},
\code{\link{plotSurvivalPvaluesByCutoff}()},
\code{\link{processSurvTerms}()},
\code{\link{survdiffTerms}()},
\code{\link{survfit.survTerms}()}
}
\concept{functions to analyse survival}
