% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{processSurvTerms}
\alias{processSurvTerms}
\title{Process survival curves terms to calculate survival curves}
\usage{
processSurvTerms(
  clinical,
  censoring,
  event,
  timeStart,
  timeStop = NULL,
  group = NULL,
  formulaStr = NULL,
  coxph = FALSE,
  scale = "days",
  followup = "days_to_last_followup",
  survTime = NULL
)
}
\arguments{
\item{clinical}{Data frame: clinical data}

\item{censoring}{Character: censor using \code{left}, \code{right},
\code{interval} or \code{interval2}}

\item{event}{Character: name of column containing time of the event of
interest}

\item{timeStart}{Character: name of column containing starting time of the
interval or follow up time}

\item{timeStop}{Character: name of column containing ending time of the
interval (only relevant for interval censoring)}

\item{group}{Character: group relative to each subject}

\item{formulaStr}{Character: formula to use}

\item{coxph}{Boolean: fit a Cox proportional hazards regression model?}

\item{scale}{Character: rescale the survival time to \code{days},
\code{weeks}, \code{months} or \code{years}}

\item{followup}{Character: name of column containing follow up time}

\item{survTime}{\code{survTime} object: times to follow up, time start, time
stop and event (optional)}
}
\value{
A list with a \code{formula} object and a data frame with terms
needed to calculate survival curves
}
\description{
Process survival curves terms to calculate survival curves
}
\details{
The \code{event} time is only used to determine whether the event
has occurred (\code{1}) or not (\code{0}) in case of missing values.

If \code{survTime = NULL}, survival times are obtained from the clinical
dataset according to the names given in \code{timeStart}, \code{timeStop},
\code{event} and \code{followup}. This may become quite slow when used in a
loop. If the aforementioned variables are constant, consider running
\code{\link{getAttributesTime}()} outside the loop and using its output via
the \code{survTime} argument of this function (see Examples).
}
\examples{
clinical <- read.table(text = "2549   NA ii  female
                                840   NA i   female
                                 NA 1204 iv    male
                                 NA  383 iv  female
                               1293   NA iii   male
                                 NA 1355 ii    male")
names(clinical) <- c("patient.days_to_last_followup",
                     "patient.days_to_death",
                     "patient.stage_event.pathologic_stage",
                     "patient.gender")
timeStart  <- "days_to_death"
event      <- "days_to_death"
formulaStr <- "patient.stage_event.pathologic_stage + patient.gender"
survTerms  <- processSurvTerms(clinical, censoring="right", event, timeStart,
                               formulaStr=formulaStr)

# If running multiple times, consider calculating survTime only once
survTime <- getAttributesTime(clinical, event, timeStart)
for (i in seq(5)) {
  survTerms <- processSurvTerms(clinical, censoring="right", event,
                                timeStart, formulaStr=formulaStr,
                                survTime=survTime)
}
}
\seealso{
Other functions to analyse survival: 
\code{\link{assignValuePerSubject}()},
\code{\link{getAttributesTime}()},
\code{\link{labelBasedOnCutoff}()},
\code{\link{optimalSurvivalCutoff}()},
\code{\link{plotSurvivalCurves}()},
\code{\link{plotSurvivalPvaluesByCutoff}()},
\code{\link{survdiffTerms}()},
\code{\link{survfit.survTerms}()},
\code{\link{testSurvival}()}
}
\concept{functions to analyse survival}
