% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{getNumerics}
\alias{getNumerics}
\title{Convert a column to numeric if possible and ignore given columns composed
of lists}
\usage{
getNumerics(table, by = NULL, toNumeric = FALSE)
}
\arguments{
\item{table}{Data matrix: table}

\item{by}{Character: column names of interest}

\item{toNumeric}{Boolean: which columns to convert to numeric}
}
\value{
Processed data matrix
}
\description{
Convert a column to numeric if possible and ignore given columns composed
of lists
}
\examples{
event <- read.table(text = "ABC123 + 250 300 350
                            DEF456 - 900 800 700")
names(event) <- c("Event ID", "Strand", "C1.end", "A1.end", "A1.start")

# Let's change one column to character
event[ , "C1.end"] <- as.character(event[ , "C1.end"])
is.character(event[ , "C1.end"])

event <- psichomics:::getNumerics(event, by = c("Strand", "C1.end", "A1.end",
                                  "A1.start"),
                                  toNumeric = c(FALSE, TRUE, TRUE, TRUE))
# Let's check if the same column is now integer
is.numeric(event[ , "C1.end"])
}
\keyword{internal}
