% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plyxp-class.R
\docType{class}
\name{new_plyxp}
\alias{new_plyxp}
\alias{PlySummarizedExperiment}
\alias{PlySummarizedExperiment-class}
\title{SummarizedExperiment Shell Object}
\usage{
new_plyxp(se)

PlySummarizedExperiment(se)
}
\arguments{
\item{se}{SummarizedExperiment object}
}
\value{
PlySummarizedExperiment object
}
\description{
A container object for the SummarizedExperiment class.

This S4 class is implemented to bring unique \code{dplyr}
syntax to the \code{SummarizedExperiment} object without clashing with the
\code{tidySummarizedExperiment} package. As such, this is a simple wrapper that
contains one slot, which holds a \code{SummarizedExperiment} object.
}
\section{Slots}{

\describe{
\item{\code{se}}{contains the underlying \code{SummarizedExperiment} class.}
}}

\examples{
se <- SummarizedExperiment(
  assays = list(counts = matrix(1:6, nrow = 3)),
  colData = S4Vectors::DataFrame(condition = c("A", "B"))
)
new_plyxp(se = se)
# or
PlySummarizedExperiment(se = se)
}
