% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-select.R
\name{select.Ranges}
\alias{select.Ranges}
\title{Select metadata columns of the Ranges object by name or position}
\usage{
\method{select}{Ranges}(.data, ..., .drop_ranges = FALSE)
}
\arguments{
\item{.data}{a \code{Ranges} object}

\item{...}{One or more metadata column names.}

\item{.drop_ranges}{If TRUE select will always return a tibble. In this
case, you may select columns that form the core part of the Ranges object.}
}
\value{
a Ranges object or a tibble
}
\description{
Select metadata columns of the Ranges object by name or position
}
\details{
Note that by default select only acts on the metadata columns (and
will therefore return a Ranges object) if a core component of a Ranges is dropped or selected
without the other required components (this includes the seqnames, strand, start, end,
width names), then select will throw an error unless .drop_ranges is set to TRUE.
}
\examples{
df <- data.frame(start = 1:10, width = 5,  seqnames = "seq1",
strand = sample(c("+", "-", "*"), 10, replace = TRUE), gc = runif(10), counts = rpois(10, 2))
rng <- as_granges(df)
select(rng, -gc)
select(rng, gc)
select(rng, counts, gc)
select(rng, 2:1)
select(rng, seqnames, strand, .drop_ranges = TRUE)
}
\seealso{
\code{\link[dplyr:select]{dplyr::select()}}
}
