% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadGEO.R
\name{getGSE}
\alias{getGSE}
\title{Load ExpressionSet from GEO Series}
\usage{
getGSE(
  name,
  destdir = getPhantasusConf("cache_folders")$geo_path,
  mirrorPath = getPhantasusConf("geo_mirrors")
)
}
\arguments{
\item{name}{String, containing GEO identifier of the dataset.
It should start with 'GSE' or 'GDS' and can include exact GPL
to annotate dataset, separated with dash ('-') from the identifier.}

\item{destdir}{Directory for caching loaded Series and GPL
files from GEO database.}

\item{mirrorPath}{URL string which specifies the source of matrices.}
}
\value{
List of ExpressionSet objects, that were available by given
    in \code{name} variable GEO identifier.
}
\description{
\code{getGSE} return the ExpressionSet object(s) corresponding
    to GEO Series Identifier.
}
\examples{
\dontrun{
    getGSE('GSE14308', destdir = 'cache')
    getGSE('GSE27112')
    getGSE('GSE53986')
}

}
