% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadGEO.R
\name{getGDS}
\alias{getGDS}
\title{Load ExpressionSet from GEO Datasets}
\usage{
getGDS(
  name,
  destdir = getPhantasusConf("cache_folders")$geo_path,
  mirrorPath = getPhantasusConf("geo_mirrors")
)
}
\arguments{
\item{name}{String, containing GEO identifier of the dataset.
It should start with 'GSE' or 'GDS' and can include exact GPL
to annotate dataset, separated with dash ('-') from the identifier.}

\item{destdir}{Directory for caching loaded Series and GPL
files from GEO database.}

\item{mirrorPath}{URL string which specifies the source of matrices.}
}
\value{
ExpressionSet object wrapped in list, that was available by given
    in \code{name} variable GEO identifier.
}
\description{
\code{getGDS} return the ExpressionSet object corresponding
    to GEO Dataset identifier.
}
\examples{
\dontrun{
   getGDS('GDS4922', destdir = tempdir(), mirrorPath = "https://ftp.ncbi.nlm.nih.gov")
}
}
