% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_genes.R
\name{map_genes}
\alias{map_genes}
\title{Map genes}
\usage{
map_genes(
  genes,
  species = "hsapiens",
  target = "ENSG",
  mthreshold = Inf,
  drop_na = FALSE,
  numeric_ns = "",
  run_map_species = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{genes}{Gene list.}

\item{species}{Species to map against.}

\item{target}{target namespace.}

\item{mthreshold}{maximum number of results per initial alias to show. Shows all by default.}

\item{drop_na}{Drop all genes without mappings.
Sets \code{gprofiler2::gconvert(filter_na=)} as well
an additional round of more comprehensive \code{NA} filtering
by \pkg{orthogene}.}

\item{numeric_ns}{namespace to use for fully numeric IDs (\href{https://biit.cs.ut.ee/gprofiler/page/namespaces-list}{list of available namespaces}).}

\item{run_map_species}{Standardise \code{species} names with 
\link[orthogene]{map_species} first (Default: \code{TRUE}).}

\item{verbose}{Print messages.}
}
\value{
Table with standardised genes.
}
\description{
Input a list of genes, transcripts, proteins, SNPs,
or genomic ranges in any format
(HGNC, Ensembl, RefSeq, UniProt, etc.) and return
a table with standardised gene symbols
 (the "names" column).
}
\details{
Uses \link[gprofiler2]{gconvert}.
The exact contents of the output table will depend on
\code{target} parameter.
See \code{?gprofiler2::gconvert} for more details.
}
\examples{
genes <- c(
    "Klf4", "Sox2", "TSPAN12", "NM_173007", "Q8BKT6",
    "ENSMUSG00000012396", "ENSMUSG00000074637"
)
mapped_genes <- map_genes(
    genes = genes,
    species = "mouse"
)
}
