% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/many2many_rows.R
\name{many2many_rows}
\alias{many2many_rows}
\title{Expand/aggregate rows of matrix for many:many mappings}
\source{
\code{
data("exp_mouse")
X <- exp_mouse 
gene_map <- orthogene:::map_orthologs(genes = rownames(exp_mouse),
                                      input_species = "mouse",
                                      method="homologene")
X_agg <- orthogene:::many2many_rows(X = X,
                                    gene_map = gene_map)
sum(duplicated(rownames(exp_mouse))) # 0                                      
sum(duplicated(gene_map$input_gene)) # 46
sum(duplicated(gene_map$ortholog_gene)) # 56
sum(duplicated(rownames(X_agg))) # 56
}
}
\usage{
many2many_rows(
  X,
  gene_map,
  input_col = "input_gene",
  output_col = "ortholog_gene",
  agg_fun = "sum",
  agg_method = c("monocle3", "stats"),
  as_sparse = TRUE,
  as_DelayedArray = FALSE,
  dropNA = TRUE,
  aggregate_orthologs = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{X}{Input matrix.}

\item{gene_map}{A \link[base]{data.frame} generated by
 \link[orthogene]{map_orthologs}, 
with columns mapping \code{input_col} to \code{output_col}.}

\item{input_col}{Column name within \code{gene_map} with gene names matching 
the row names of \code{X}.}

\item{output_col}{Column name within \code{gene_map} with gene names
that you wish you map the row names of \code{X} onto.}

\item{agg_fun}{Aggregation function.}

\item{agg_method}{Aggregation method.}

\item{as_sparse}{Convert aggregated matrix to sparse matrix.}

\item{as_DelayedArray}{Convert aggregated matrix to
\link[DelayedArray]{DelayedArray}.}

\item{dropNA}{Drop genes assigned to \code{NA} in \code{groupings}.}

\item{aggregate_orthologs}{[Optional] After performing an initial round of 
many:many aggregation/expansion with \link[orthogene]{many2many_rows},
 ensure each orthologous gene only appears in one row by using the 
\link[orthogene]{aggregate_rows} function (default: \code{TRUE}).}

\item{verbose}{Print messages.}
}
\value{
Expanded/aggregated matrix.
}
\description{
Expand/aggregate rows of a matrix with any combination of 
 many:many mappings. 
This method ensures that total counts per gene remain the
same regardless of how many genes it has split/condensed into.
This allows for many:many mappings that are otherwise not possible
using standard aggregation functions,
since they all require many:1 scenarios.\cr
Internally, this is done as follows:
\itemize{
\item{Identify genes that appear more than once
 in \code{gene_map[[input_col]]}.}
\item{For each gene identified, split its row into multiple
 rows, where the number of new rows is equal to the number of times that
 gene appears within \code{gene_map[[input_col]]}.
In the new expanded matrix, each row will be equal to the column sums
divided by the number of new rows. This means that averaged counts will be 
split equally amongst the new rows, in a column-specific manner.\cr
Thus, the column sums of the output matrix will be equal 
to the column sums in the input matrix. 
In the case of gene expression count matrices,
 this means that the total counts will remain equal between matrices, 
 while avoiding being forced to drop genes with many:many mappings 
 (as is the case with most other aggregation methods). } 
\item{Map rownames of the expanded matrix onto the orthologous gene names
from \code{gene_map$ortholog_gene}.}
\item{[Optional] When \code{aggregate_orthologs=TRUE}, 
aggregate rows of the expanded/mapped matrix 
such that there will only be 1 row per ortholog gene, 
using \link[orthogene]{aggregate_rows}. 
The arguments \code{FUN}, \code{method}, 
\code{as_sparse}, \code{as_DelayedArray}, and \code{dropNA} will all
be passed to \link[orthogene]{aggregate_rows} if this step is selected.}
}
}
\keyword{internal}
