% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omXplore_intensity.R, R/plot_boxplot.R,
%   R/plot_violin.R
\name{intensity-plots}
\alias{intensity-plots}
\alias{omXplore_intensity_ui}
\alias{omXplore_intensity_server}
\alias{omXplore_intensity}
\alias{boxPlot}
\alias{violinPlot}
\title{Displays different intensity plots.}
\usage{
omXplore_intensity_ui(id)

omXplore_intensity_server(
  id,
  dataIn = reactive({
     NULL
 }),
  i = reactive({
     1
 }),
  track.indices = reactive({
     NULL
 }),
  remoteReset = reactive({
     NULL
 }),
  is.enabled = reactive({
     TRUE
 })
)

omXplore_intensity(dataIn, i = NULL, withTracking = FALSE)

boxPlot(obj, conds, legend = NULL, pal = NULL, subset = NULL)

violinPlot(data, conds, subset = NULL, pal.name = "Set1")
}
\arguments{
\item{id}{A \code{character(1)} which is the id of the shiny module.}

\item{dataIn}{A instance of the class \code{MultiAssayExperiment}}

\item{i}{An integer which is the index of the assay in the param obj}

\item{track.indices}{A vector of integers which are the indices of
lines to track.}

\item{remoteReset}{An integer to activate the reset functions}

\item{is.enabled}{A boolean that indicates whether the widgets should be
enabled or disabled. Default is TRUE}

\item{withTracking}{A \code{boolean(1)} indicating whether the tracking option is
activated or not.}

\item{obj}{xxxx}

\item{conds}{A vector indicating the name of each sample.}

\item{legend}{A vector of the conditions (one condition per sample).}

\item{pal}{A basis palette for the boxes which length must be equal
to the number of unique conditions in the dataset.}

\item{subset}{A \code{integer()} vector of index indicating the indices
of rows in the dataset to highlight}

\item{data}{xxxx}

\item{pal.name}{A \code{character(1)} which is the name of the palette from the
package \link{RColorBrewer} from which the colors are taken. Default value
is 'Set1'.}
}
\value{
NA

NA

A shiny app

A boxplot

A violin plot
}
\description{
Displays different intensity plots.
}
\examples{
\dontrun{
  data(vdata)
  shiny::runApp(omXplore_intensity(vdata, 1))
  
data(sub_R25)
conds <- legend <- SummarizedExperiment::colData(sub_R25)$group
pal <- ExtendPalette(length(unique(conds)))
boxPlot(sub_R25[[1]], conds, legend, pal, seq_len(10))

shiny::runApp(omXplore_intensity(sub_R25, 1, withTracking = TRUE))
}

}
\author{
Samuel Wieczorek, Anais Courtier, Enora Fremy
}
