% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootRanges.R
\name{bootRanges}
\alias{bootRanges}
\title{Block bootstrap for genomic ranges}
\usage{
bootRanges(
  y,
  blockLength,
  R = 1,
  seg = NULL,
  exclude = NULL,
  excludeOption = c("drop", "trim"),
  proportionLength = TRUE,
  type = c("bootstrap", "permute"),
  withinChrom = FALSE,
  storeBlockLength = FALSE
)
}
\arguments{
\item{y}{the GRanges to bootstrap sample}

\item{blockLength}{the length of the blocks
(for proportional blocks, this is the maximal length of a block)}

\item{R}{the number of bootstrap samples to generate}

\item{seg}{the segmentation GRanges, with a column ("state")
indicating segmentation state (optional)}

\item{exclude}{the GRanges of excluded regions (optional)}

\item{excludeOption}{whether to \code{"drop"} or \code{"trim"}
bootstrap ranges that overlap a excluded region}

\item{proportionLength}{for the segmented block bootstrap,
whether to use scaled block lengths (scaling by the proportion
of the segmentation state out of the total genome length).
That is, the resulting blocks will be of size less than
\code{blockLength}}

\item{type}{the type of null generation (un-segmented bootstrap only)}

\item{withinChrom}{whether to re-sample (bootstrap) ranges
across chromosomes (default) or only within chromosomes
(un-segmented bootstrap only)}

\item{storeBlockLength}{whether to save blockLength as a
metadata column}
}
\value{
a BootRanges (GRanges object) with the bootstrapped ranges,
where iteration and block length are recorded as metadata columns
}
\description{
Performs a block bootstrap, optionally with respect
to a genome segmentation. Returns a \code{bootRanges} object,
which is a GRanges object with all the ranges from the
bootstrap iterations concatenated.
}
\details{
Note that this function requires input ranges have associated
\code{seqlengths}, and that these must not be shorter than \code{blockLength}.
See \code{Seqinfo}, \code{seqlevels}, and \code{keepStandardChromosomes} functions
and their use in the Quick Start section of the vignette.
}
\examples{

set.seed(1)
library(GenomicRanges)
gr <- GRanges("chr1", IRanges(0:4 * 10 + 1, width=5),
              seqlengths=c(chr1=50))
br <- bootRanges(gr, blockLength=10)

}
\references{
bootRanges manuscript:

Wancen Mu, Eric S. Davis, Stuart Lee, Mikhail G. Dozmorov,
Douglas H. Phanstiel, Michael I. Love.
2023. "bootRanges: Flexible generation of null sets
of genomic ranges for hypothesis testing."
Bioinformatics. doi: 10.1093/bioinformatics/btad190

Original method describing the segmented block bootstrap for genomic features:

Bickel, Peter J., Nathan Boley, James B. Brown,
Haiyan Huang, and Nancy R. Zhang.
2010. "Subsampling Methods for Genomic Inference."
The Annals of Applied Statistics 4 (4): 1660–97.
doi: 10.1214/10-AOAS363
}
