## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "##"
)

## ----eval = FALSE-------------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# BiocManager::install("notame")
# library(notame)

## -----------------------------------------------------------------------------
library(notame)
data(toy_notame_set, package = "notame")
se <- toy_notame_set
names(assays(se)) <- "rawbundances"
# Mark missing values as NA
se <- mark_nas(se, value = 0)
# Correct drift
se <- correct_drift(se, name = "dc")

## -----------------------------------------------------------------------------
se <- flag_detection(se, assay.type = "dc")
se <- flag_quality(se, assay.type = "dc")
head(rowData(se)$Flag)

## -----------------------------------------------------------------------------
set.seed(2025)
se <- impute_rf(se, assay.type = "dc", name = "imputed")

## ----echo = FALSE-------------------------------------------------------------
knitr::include_graphics("Data_input.png")

## ----eval = FALSE-------------------------------------------------------------
# BiocParallel::register(BiocParallel::SerialParam())

## ----echo = FALSE-------------------------------------------------------------
sessionInfo()

