% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{drop_flagged}
\alias{drop_flagged}
\title{Drop flagged features}
\usage{
drop_flagged(object, all_features = FALSE)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{all_features}{logical, should all features be retained? Mainly used by 
internal functions}
}
\value{
A SummarizedExperiment object without the previously 
flagged features.
}
\description{
Removes all features that have been flagged by quality control functions.
Only features that do not have a flag (Flag == NA) are retained.
}
\examples{
data(toy_notame_set)
dim(toy_notame_set)
flagged <- flag_quality(toy_notame_set)
noflags <- drop_flagged(flagged)
dim(noflags)

}
