% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSeqLengthDistn.R
\docType{methods}
\name{plotSeqLengthDistn}
\alias{plotSeqLengthDistn}
\alias{plotSeqLengthDistn,ANY-method}
\alias{plotSeqLengthDistn,character-method}
\alias{plotSeqLengthDistn,FastqcData-method}
\alias{plotSeqLengthDistn,FastqcDataList-method}
\title{Plot the Sequence Length Distribution}
\usage{
plotSeqLengthDistn(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  ...
)

\S4method{plotSeqLengthDistn}{ANY}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  ...
)

\S4method{plotSeqLengthDistn}{character}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  ...
)

\S4method{plotSeqLengthDistn}{FastqcData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  counts = TRUE,
  plotType = c("line", "cdf"),
  expand.x = c(0, 0.2, 0, 0.2),
  plotlyLegend = FALSE,
  colour = "red",
  ...
)

\S4method{plotSeqLengthDistn}{FastqcDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  counts = FALSE,
  plotType = c("heatmap", "line", "cdf"),
  cluster = FALSE,
  dendrogram = FALSE,
  heat_w = 8,
  pwfCols,
  showPwf = TRUE,
  scaleFill = NULL,
  scaleColour = NULL,
  heatCol = hcl.colors(50, "inferno"),
  plotlyLegend = FALSE,
  ...
)
}
\arguments{
\item{x}{Can be a \code{FastqcData}, \code{FastqcDataList} or file paths}

\item{usePlotly}{\code{logical}. Output as ggplot2 or plotly object.}

\item{labels}{An optional named vector of labels for the file names.
All filenames must be present in the names.}

\item{pattern}{Regex to remove from the end of any filenames}

\item{...}{Used to pass additional attributes to theme()}

\item{counts}{\code{logical} Should distributions be shown as counts or
frequencies (percentages)}

\item{plotType}{\code{character}. Can only take the values
\code{plotType = "heatmap"} \code{plotType = "line"} or
\code{plotType = "cdf"}}

\item{expand.x}{Output from \code{expansion()} or numeric vector of
length 4. Passed to \code{scale_x_discrete}}

\item{plotlyLegend}{logical(1) Show legend for interactive line plots}

\item{colour}{Line colour}

\item{cluster}{\code{logical} default \code{FALSE}. If set to \code{TRUE},
fastqc data will be clustered using hierarchical clustering}

\item{dendrogram}{\code{logical} redundant if \code{cluster} and
\code{usePlotly} are \code{FALSE}. If both \code{cluster} and
\code{dendrogram} are specified as \code{TRUE} then the dendrogram
will be displayed.}

\item{heat_w}{Relative width of any heatmap plot components}

\item{pwfCols}{Object of class \code{\link[=PwfCols]{PwfCols()}} to give colours for
pass, warning, and fail values in plot}

\item{showPwf}{logical(1) Show PASS/WARN/FAIL status}

\item{scaleFill, scaleColour}{Optional ggplot scale objects}

\item{heatCol}{The colour scheme for the heatmap}
}
\value{
A standard ggplot2 object, or an interactive plotly object
}
\description{
Plot the Sequence Length Distribution across one or more FASTQC
reports
}
\details{
This extracts the Sequence Length Distribution from the supplied object and
generates a ggplot2 object, with a set of minimal defaults.
The output of this function can be further modified using the standard
ggplot2 methods.

A cdf plot can also be generated to provide guidance for minimum
read length in some NGS workflows, by setting \code{plotType = "cdf"}.
If all libraries have reads of identical lengths, these plots may be less
informative.

An alternative interactive plot is available by setting the argument
\code{usePlotly = TRUE}.
}
\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)

# Plot as a frequency plot using lines
plotSeqLengthDistn(fdl)

# Or plot the cdf
plotSeqLengthDistn(fdl, plotType = "cdf")

}
