/*
  File autogenerated by gengetopt version 2.19.1
  generated with the following command:
  gengetopt --file-name=HashingMergerMain.cmdline  

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "HashingMergerMain.cmdline.h"

const char *gengetopt_args_info_purpose = "Fast sorting and updating of cluster indices for input edges. Output edges are \nsplit into two (unchanged and changed), or multiple (unchanged, and multiple \nchanged based on hashing) files, while maintaining the original order for valid \nedges.  Input edges are read from stdin.";

const char *gengetopt_args_info_usage = "Usage: edges2valid_clusters [OPTIONS]...";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "  -e, --existing-edges-file=STRING\n                                Output file for unchanged edges, order \n                                  maintained",
  "  -w, --new-edges-file=STRING   Output file for newly born thick edges, not \n                                  necessarily sorted",
  "  -s, --sizes-file=STRING       Output file for sizes computed from tree",
  "  -t, --tree-file=filename      Filename containing the tree",
  "  -x, --missing-val=distance    The defualt weight for missing edges  \n                                  (default=`100')",
  "This is the value used when computing the distances from a new born cluster \nwhen one of the averaged edges is missing.",
  "  -n, --num-splits=INT          split the new edges file into this number of \n                                  files",
  "This option splits the output file of modified edges into several files, and \nguarantees that all edges with the same cluster IDs will appear in the same \nsingle output file, by using a hash function on the up-to-date cluster IDs.",
    0
};

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->existing_edges_file_given = 0 ;
  args_info->new_edges_file_given = 0 ;
  args_info->sizes_file_given = 0 ;
  args_info->tree_file_given = 0 ;
  args_info->missing_val_given = 0 ;
  args_info->num_splits_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->existing_edges_file_arg = NULL;
  args_info->existing_edges_file_orig = NULL;
  args_info->new_edges_file_arg = NULL;
  args_info->new_edges_file_orig = NULL;
  args_info->sizes_file_arg = NULL;
  args_info->sizes_file_orig = NULL;
  args_info->tree_file_arg = NULL;
  args_info->tree_file_orig = NULL;
  args_info->missing_val_arg = 100;
  args_info->missing_val_orig = NULL;
  args_info->num_splits_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{
  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->existing_edges_file_help = gengetopt_args_info_help[2] ;
  args_info->new_edges_file_help = gengetopt_args_info_help[3] ;
  args_info->sizes_file_help = gengetopt_args_info_help[4] ;
  args_info->tree_file_help = gengetopt_args_info_help[5] ;
  args_info->missing_val_help = gengetopt_args_info_help[6] ;
  args_info->num_splits_help = gengetopt_args_info_help[7] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  printf("\n%s\n\n", gengetopt_args_info_usage);

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n", gengetopt_args_info_description);

  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  
  if (args_info->existing_edges_file_arg)
    {
      free (args_info->existing_edges_file_arg); /* free previous argument */
      args_info->existing_edges_file_arg = 0;
    }
  if (args_info->existing_edges_file_orig)
    {
      free (args_info->existing_edges_file_orig); /* free previous argument */
      args_info->existing_edges_file_orig = 0;
    }
  if (args_info->new_edges_file_arg)
    {
      free (args_info->new_edges_file_arg); /* free previous argument */
      args_info->new_edges_file_arg = 0;
    }
  if (args_info->new_edges_file_orig)
    {
      free (args_info->new_edges_file_orig); /* free previous argument */
      args_info->new_edges_file_orig = 0;
    }
  if (args_info->sizes_file_arg)
    {
      free (args_info->sizes_file_arg); /* free previous argument */
      args_info->sizes_file_arg = 0;
    }
  if (args_info->sizes_file_orig)
    {
      free (args_info->sizes_file_orig); /* free previous argument */
      args_info->sizes_file_orig = 0;
    }
  if (args_info->tree_file_arg)
    {
      free (args_info->tree_file_arg); /* free previous argument */
      args_info->tree_file_arg = 0;
    }
  if (args_info->tree_file_orig)
    {
      free (args_info->tree_file_orig); /* free previous argument */
      args_info->tree_file_orig = 0;
    }
  if (args_info->missing_val_orig)
    {
      free (args_info->missing_val_orig); /* free previous argument */
      args_info->missing_val_orig = 0;
    }
  if (args_info->num_splits_orig)
    {
      free (args_info->num_splits_orig); /* free previous argument */
      args_info->num_splits_orig = 0;
    }
  
  clear_given (args_info);
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  if (args_info->help_given) {
    fprintf(outfile, "%s\n", "help");
  }
  if (args_info->version_given) {
    fprintf(outfile, "%s\n", "version");
  }
  if (args_info->existing_edges_file_given) {
    if (args_info->existing_edges_file_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "existing-edges-file", args_info->existing_edges_file_orig);
    } else {
      fprintf(outfile, "%s\n", "existing-edges-file");
    }
  }
  if (args_info->new_edges_file_given) {
    if (args_info->new_edges_file_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "new-edges-file", args_info->new_edges_file_orig);
    } else {
      fprintf(outfile, "%s\n", "new-edges-file");
    }
  }
  if (args_info->sizes_file_given) {
    if (args_info->sizes_file_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "sizes-file", args_info->sizes_file_orig);
    } else {
      fprintf(outfile, "%s\n", "sizes-file");
    }
  }
  if (args_info->tree_file_given) {
    if (args_info->tree_file_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "tree-file", args_info->tree_file_orig);
    } else {
      fprintf(outfile, "%s\n", "tree-file");
    }
  }
  if (args_info->missing_val_given) {
    if (args_info->missing_val_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "missing-val", args_info->missing_val_orig);
    } else {
      fprintf(outfile, "%s\n", "missing-val");
    }
  }
  if (args_info->num_splits_given) {
    if (args_info->num_splits_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "num-splits", args_info->num_splits_orig);
    } else {
      fprintf(outfile, "%s\n", "num-splits");
    }
  }
  
  fclose (outfile);

  i = EXIT_SUCCESS;
  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}


/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, NULL) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error = 0;

  /* checks for required options */
  if (! args_info->existing_edges_file_given)
    {
      fprintf (stderr, "%s: '--existing-edges-file' ('-e') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->new_edges_file_given)
    {
      fprintf (stderr, "%s: '--new-edges-file' ('-w') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->tree_file_given)
    {
      fprintf (stderr, "%s: '--tree-file' ('-t') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  
  /* checks for dependences among options */

  return error;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "existing-edges-file",	1, NULL, 'e' },
        { "new-edges-file",	1, NULL, 'w' },
        { "sizes-file",	1, NULL, 's' },
        { "tree-file",	1, NULL, 't' },
        { "missing-val",	1, NULL, 'x' },
        { "num-splits",	1, NULL, 'n' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVe:w:s:t:x:n:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'e':	/* Output file for unchanged edges, order maintained.  */
          if (local_args_info.existing_edges_file_given)
            {
              fprintf (stderr, "%s: `--existing-edges-file' (`-e') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->existing_edges_file_given && ! override)
            continue;
          local_args_info.existing_edges_file_given = 1;
          args_info->existing_edges_file_given = 1;
          if (args_info->existing_edges_file_arg)
            free (args_info->existing_edges_file_arg); /* free previous string */
          args_info->existing_edges_file_arg = gengetopt_strdup (optarg);
          if (args_info->existing_edges_file_orig)
            free (args_info->existing_edges_file_orig); /* free previous string */
          args_info->existing_edges_file_orig = gengetopt_strdup (optarg);
          break;

        case 'w':	/* Output file for newly born thick edges, not necessarily sorted.  */
          if (local_args_info.new_edges_file_given)
            {
              fprintf (stderr, "%s: `--new-edges-file' (`-w') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->new_edges_file_given && ! override)
            continue;
          local_args_info.new_edges_file_given = 1;
          args_info->new_edges_file_given = 1;
          if (args_info->new_edges_file_arg)
            free (args_info->new_edges_file_arg); /* free previous string */
          args_info->new_edges_file_arg = gengetopt_strdup (optarg);
          if (args_info->new_edges_file_orig)
            free (args_info->new_edges_file_orig); /* free previous string */
          args_info->new_edges_file_orig = gengetopt_strdup (optarg);
          break;

        case 's':	/* Output file for sizes computed from tree.  */
          if (local_args_info.sizes_file_given)
            {
              fprintf (stderr, "%s: `--sizes-file' (`-s') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->sizes_file_given && ! override)
            continue;
          local_args_info.sizes_file_given = 1;
          args_info->sizes_file_given = 1;
          if (args_info->sizes_file_arg)
            free (args_info->sizes_file_arg); /* free previous string */
          args_info->sizes_file_arg = gengetopt_strdup (optarg);
          if (args_info->sizes_file_orig)
            free (args_info->sizes_file_orig); /* free previous string */
          args_info->sizes_file_orig = gengetopt_strdup (optarg);
          break;

        case 't':	/* Filename containing the tree.  */
          if (local_args_info.tree_file_given)
            {
              fprintf (stderr, "%s: `--tree-file' (`-t') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->tree_file_given && ! override)
            continue;
          local_args_info.tree_file_given = 1;
          args_info->tree_file_given = 1;
          if (args_info->tree_file_arg)
            free (args_info->tree_file_arg); /* free previous string */
          args_info->tree_file_arg = gengetopt_strdup (optarg);
          if (args_info->tree_file_orig)
            free (args_info->tree_file_orig); /* free previous string */
          args_info->tree_file_orig = gengetopt_strdup (optarg);
          break;

        case 'x':	/* The defualt weight for missing edges.  */
          if (local_args_info.missing_val_given)
            {
              fprintf (stderr, "%s: `--missing-val' (`-x') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->missing_val_given && ! override)
            continue;
          local_args_info.missing_val_given = 1;
          args_info->missing_val_given = 1;
          args_info->missing_val_arg = (float)strtod (optarg, &stop_char);
          if (!(stop_char && *stop_char == '\0')) {
            fprintf(stderr, "%s: invalid numeric value: %s\n", argv[0], optarg);
            goto failure;
          }
          if (args_info->missing_val_orig)
            free (args_info->missing_val_orig); /* free previous string */
          args_info->missing_val_orig = gengetopt_strdup (optarg);
          break;

        case 'n':	/* split the new edges file into this number of files.  */
          if (local_args_info.num_splits_given)
            {
              fprintf (stderr, "%s: `--num-splits' (`-n') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->num_splits_given && ! override)
            continue;
          local_args_info.num_splits_given = 1;
          args_info->num_splits_given = 1;
          args_info->num_splits_arg = strtol (optarg, &stop_char, 0);
          if (!(stop_char && *stop_char == '\0')) {
            fprintf(stderr, "%s: invalid numeric value: %s\n", argv[0], optarg);
            goto failure;
          }
          if (args_info->num_splits_orig)
            free (args_info->num_splits_orig); /* free previous string */
          args_info->num_splits_orig = gengetopt_strdup (optarg);
          break;


        case 0:	/* Long option with no short option */
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
      error += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
