% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netboost.R
\name{nb_mcupgma}
\alias{nb_mcupgma}
\title{Calculate dendrogram for a sparse distance matrix
(external wrapper MC-UPGMA clustering package Loewenstein et al.}
\usage{
nb_mcupgma(
  filter,
  dist,
  max_singleton,
  cores = getOption("mc.cores", 2L),
  verbose = getOption("verbose")
)
}
\arguments{
\item{filter}{Filter-Matrix as generated by the nb_filter function.}

\item{dist}{Distance-Matrix as generated by the nb_dist function.}

\item{max_singleton}{Integer The maximal singleton in the clustering.
Usually equals the number of features.}

\item{cores}{Integer Amount of CPU cores used (<=1 : sequential)}

\item{verbose}{Logical Additional diagnostic messages.}
}
\value{
Raw dendrogram to be processed by tree_search and tree_dendro.
}
\description{
Calculate dendrogram for a sparse distance matrix
(external wrapper MC-UPGMA clustering package Loewenstein et al.
}
\examples{
   data('tcga_aml_meth_rna_chr18', package='netboost')
   cores <- as.integer(getOption('mc.cores', 2))
   datan <- as.data.frame(scale(tcga_aml_meth_rna_chr18,
   center=TRUE, scale=TRUE))
   filter <- nb_filter(datan=datan, stepno=20L, until=0L,
                       progress=1000L, cores=cores, mode=2L)
   dist <- nb_dist(datan=datan, filter=filter, soft_power=3L, cores=cores)
   max_singleton = dim(tcga_aml_meth_rna_chr18)[2]
   forest <- nb_mcupgma(filter=filter, dist=dist,
                        max_singleton=max_singleton, cores=cores)
 head(forest)

}
