% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAdf2se.R
\name{RNAdf2se}
\alias{RNAdf2se}
\title{Convert a \code{mobileRNA} dataframe to a SummarizedExperiment object}
\usage{
RNAdf2se(input = c("sRNA", "mRNA"), data)
}
\arguments{
\item{input}{character; must be either "sRNA" or "mRNA"}

\item{data}{data.frame produced by the \pkg{mobileRNA} package.}
}
\value{
A \code{SummarizedExperiment} object containing information from working
data frame.

#'\strong{For sRNAseq data}
\itemize{
\item The rownames contain the locus name and the cluster name.
\item The assays represent the additional information including DicerCall, Count, RPM, MajorRNA.
\item The rowData includes the Cluster ID, the DicerCounts & the DicerConsensus.
\item The colnames represents the sample replicate names.
}

\strong{For mRNAseq data}
\itemize{
\item The rownames contain the gene names.
\item The assays represent the additional information including Count & FPKM.
\item The rowData includes the gene & the SampleCounts.
\item The colnames represents the sample replicate names.
}
}
\description{
Convert any \code{mobileRNA} output dataframe into a SummarizedExperiment object.
}
\details{
The function relies on the naming structure of columns created by functions
in the \pkg{mobileRNA} package. It is able to extract the sample names
based on these additions, and organise the data appropriately.
}
\examples{
# load data.frame
data("sRNA_data")

se <- RNAdf2se(input = "sRNA", data = sRNA_data)

}
