% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-InteractionJaggedArray.R
\name{findOverlaps}
\alias{findOverlaps}
\alias{findOverlaps,InteractionJaggedArray,InteractionJaggedArray-method}
\alias{findOverlaps,InteractionJaggedArray,Vector-method}
\alias{findOverlaps,InteractionJaggedArray,missing-method}
\alias{countOverlaps}
\alias{countOverlaps,InteractionJaggedArray,InteractionJaggedArray-method}
\alias{countOverlaps,InteractionJaggedArray,Vector-method}
\alias{countOverlaps,InteractionJaggedArray,missing-method}
\alias{overlapsAny}
\alias{overlapsAny,InteractionJaggedArray,InteractionJaggedArray-method}
\alias{overlapsAny,InteractionJaggedArray,Vector-method}
\alias{overlapsAny,InteractionJaggedArray,missing-method}
\alias{subsetByOverlaps}
\alias{subsetByOverlaps,InteractionJaggedArray,InteractionJaggedArray-method}
\alias{subsetByOverlaps,InteractionJaggedArray,Vector-method}
\alias{subsetByOverlaps,InteractionJaggedArray,missing-method}
\title{Overlap methods for InteractionJaggedArray}
\usage{
\S4method{findOverlaps}{InteractionJaggedArray,InteractionJaggedArray}(
  query,
  subject,
  maxgap = -1L,
  minoverlap = 0L,
  type = c("any", "start", "end", "within", "equal"),
  select = c("all", "first", "last", "arbitrary"),
  ignore.strand = TRUE,
  ...,
  use.region = "both"
)

\S4method{findOverlaps}{InteractionJaggedArray,Vector}(
  query,
  subject,
  maxgap = -1L,
  minoverlap = 0L,
  type = c("any", "start", "end", "within", "equal"),
  select = c("all", "first", "last", "arbitrary"),
  ignore.strand = TRUE,
  ...,
  use.region = "both"
)

\S4method{findOverlaps}{InteractionJaggedArray,missing}(
  query,
  subject,
  maxgap = -1L,
  minoverlap = 0L,
  type = c("any", "start", "end", "within", "equal"),
  select = c("all", "first", "last", "arbitrary"),
  ignore.strand = TRUE,
  ...,
  use.region = "both"
)

\S4method{countOverlaps}{InteractionJaggedArray,InteractionJaggedArray}(
  query,
  subject,
  maxgap = -1L,
  minoverlap = 0L,
  type = c("any", "start", "end", "within", "equal"),
  select = c("all", "first", "last", "arbitrary"),
  ignore.strand = TRUE,
  ...,
  use.region = "both"
)

\S4method{countOverlaps}{InteractionJaggedArray,Vector}(
  query,
  subject,
  maxgap = -1L,
  minoverlap = 0L,
  type = c("any", "start", "end", "within", "equal"),
  select = c("all", "first", "last", "arbitrary"),
  ignore.strand = TRUE,
  ...,
  use.region = "both"
)

\S4method{countOverlaps}{InteractionJaggedArray,missing}(
  query,
  subject,
  maxgap = -1L,
  minoverlap = 0L,
  type = c("any", "start", "end", "within", "equal"),
  select = c("all", "first", "last", "arbitrary"),
  ignore.strand = TRUE,
  ...,
  use.region = "both"
)

\S4method{overlapsAny}{InteractionJaggedArray,InteractionJaggedArray}(
  query,
  subject,
  maxgap = -1L,
  minoverlap = 0L,
  type = c("any", "start", "end", "within", "equal"),
  ...,
  use.region = "both"
)

\S4method{overlapsAny}{InteractionJaggedArray,Vector}(
  query,
  subject,
  maxgap = -1L,
  minoverlap = 0L,
  type = c("any", "start", "end", "within", "equal"),
  ...,
  use.region = "both"
)

\S4method{overlapsAny}{InteractionJaggedArray,missing}(
  query,
  subject,
  maxgap = -1L,
  minoverlap = 0L,
  type = c("any", "start", "end", "within", "equal"),
  ...,
  use.region = "both"
)

\S4method{subsetByOverlaps}{InteractionJaggedArray,InteractionJaggedArray}(
  x,
  ranges,
  maxgap = -1L,
  minoverlap = 0L,
  type = c("any", "start", "end", "within", "equal"),
  invert = FALSE,
  ...,
  use.region = "both"
)

\S4method{subsetByOverlaps}{InteractionJaggedArray,Vector}(
  x,
  ranges,
  maxgap = -1L,
  minoverlap = 0L,
  type = c("any", "start", "end", "within", "equal"),
  invert = FALSE,
  ...,
  use.region = "both"
)

\S4method{subsetByOverlaps}{InteractionJaggedArray,missing}(
  x,
  ranges,
  maxgap = -1L,
  minoverlap = 0L,
  type = c("any", "start", "end", "within", "equal"),
  invert = FALSE,
  ...,
  use.region = "both"
)
}
\arguments{
\item{query, subject, x, ranges}{An InteractionJaggedArray, Vector,
GInteractions or InteractionSet object, depending on
the specified method. At least one of these must be a
`subject` can be missing if query is an
InteractionJaggedArray object.}

\item{maxgap, minoverlap, type, select}{see ?`findOverlaps` in
the GenomicRanges package.}

\item{ignore.strand}{see ?`findOverlaps` in InteractionSet
package for more information.}

\item{...}{see ?`findOverlaps` in InteractionSet package
for more information}

\item{use.region}{see ?`findOverlaps` in InteractionSet
package for more information.}

\item{invert}{Boolean (TRUE/FALSE) to invert selection.
Default is TRUE.}
}
\value{
`findOverlaps` returns a Hits object.
 `countOverlaps` returns an integer vector of
 overlaps for each interaction in `query`.
 `overlapsAny` returns a logical vector of
 overlaps for each interaction in `query`.
 `subsetByOverlaps` returns overlapping
 interactions as an InteractionJaggedArray.
}
\description{
Overlap methods for InteractionJaggedArray
}
\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Read .hic file paths
hicFiles <- c(
    marinerData::LEUK_HEK_PJA27_inter_30.hic(),
    marinerData::LEUK_HEK_PJA30_inter_30.hic()
)
names(hicFiles) <- c("FS", "WT")

## Create test interactions
gi <- read.table(text="
            1 51000000 51300000 1 51000000 51500000
            2 52000000 52300000 3 52000000 52500000
            1 150000000 150500000 1 150000000 150300000
            2 52000000 52300000 2 52000000 52800000") |>
    as_ginteractions()

## InteractionJaggedArray object
iarr <- pullHicMatrices(gi, hicFiles, 100e03, half="both")

## Shift first two ranges out of range
gi2 <- c(assignToBins(gi[1:2], binSize=100e3, pos1=-200e3), gi[3:4])

## Find overlaps
findOverlaps(iarr, gi2)
countOverlaps(iarr, gi2)
countOverlaps(iarr, gi2, maxgap=100e3)
overlapsAny(iarr, gi2)
subsetByOverlaps(iarr, gi2)
subsetByOverlaps(iarr, gi2, invert=TRUE)

}
