#' Mariner: Explore the Hi-Cs
#'
#' `mariner` is an R/Bioconductor package
#' for exploring Hi-C data. It enables users to
#' flexibly manipulate, extract, and aggregate
#' chromatin interaction data quickly and efficiently.
#'
#' Key Features:
#' \itemize{
#'  \item Manipulating Paired Ranges - 
#'  Convert, bin, and shift paired genomic ranges.
#'  \item Clustering & Merging Interactions - 
#'  Group nearby interactions and select one as
#'  representative.
#'  \item Extracting & Aggregating Interactions - 
#'  Pull Hi-C pixels or matrices, then aggregate
#'  by files or interactions.
#'  \item Calculating Loop Enrichment - 
#'  Determine loop enrichment to local background
#'  with selection functions to flexibility select
#'  foreground and background.
#' }
#'
#' For more details on the features of `mariner`, read
#' the vignette: `browseVignettes(package="mariner")`
"_PACKAGE"
