% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KYCG_plot.R
\name{KYCG_plotWaterfall}
\alias{KYCG_plotWaterfall}
\title{create a waterfall plot of log(estimate) given test enrichment}
\usage{
KYCG_plotWaterfall(
  df,
  order_by = "Log2(OR)",
  size_by = "-log10(FDR)",
  label_by = "dbname",
  n_label = 10
)
}
\arguments{
\item{df}{data frame where each row is a database with test
enrichment result}

\item{order_by}{the column by which CG groups are ordered}

\item{size_by}{the column by which CG group size plot}

\item{label_by}{column in df to be used as the label (default: dbname)}

\item{n_label}{number of datapoints to label}
}
\value{
grid
}
\description{
create a waterfall plot of log(estimate) given test enrichment
}
\examples{

library(SummarizedExperiment)
library(sesameData)
df <- rowData(sesameDataGet('MM285.tissueSignature'))
query <- df$Probe_ID[df$branch == "fetal_brain" & df$type == "Hypo"]
results <- testEnrichment(query, "TFBS", platform="MM285")
KYCG_plotWaterfall(results)

}
