% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyp_to_graph.R
\name{hyp_to_graph}
\alias{hyp_to_graph}
\title{Convert a hyp object to an igraph object}
\usage{
hyp_to_graph(hyp_obj)
}
\arguments{
\item{hyp_obj}{A hyp object}
}
\value{
An igraph object
}
\description{
Convert a hyp object to an igraph object
}
\examples{
genesets <- hyperdb_rgsets("REACTOME", "70.0")

signature <- c("IDH3B","DLST","PCK2","CS","PDHB","PCK1","PDHA1","LOC642502",
               "PDHA2","LOC283398","FH","SDHD","OGDH","SDHB","IDH3A","SDHC",
               "IDH2","IDH1","OGDHL","PC","SDHA","SUCLG1","SUCLA2","SUCLG2")

hyp_obj <- hypeR(signature, genesets, background=2522)

ig <- hyp_to_graph(hyp_obj)

}
