% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inset.R
\name{geom_inset}
\alias{geom_inset}
\alias{inset}
\title{geom_inset}
\usage{
geom_inset(
  insets,
  width = 0.1,
  height = 0.1,
  hjust = 0,
  vjust = 0,
  x = "node",
  reverse_x = FALSE,
  reverse_y = FALSE
)

inset(
  tree_view,
  insets,
  width,
  height,
  hjust = 0,
  vjust = 0,
  x = "node",
  reverse_x = FALSE,
  reverse_y = FALSE
)
}
\arguments{
\item{insets}{a list of ggplot objects, named by node number}

\item{width}{width of the inset, relative to the range of x-axis, defaults to .1}

\item{height}{height of the inset, relative to the range of y-axis, defaults to .1}

\item{hjust}{adjust the horizontal position of the charts, charts will go left if hjust > 0}

\item{vjust}{adjust the vertical position of the charts, charts will go down if vjust > 0}

\item{x}{the position where users want to place the charts, one of 'node' (default) and 'branch'}

\item{reverse_x}{whether to reverse x axis of the charts by 'ggplot2::scale_x_reverse', defaults to 'FALSE'}

\item{reverse_y}{whether to reverse y axis of the charts by 'ggplot2::scale_y_reverse', defaults to 'FALSE'}

\item{tree_view}{tree view}
}
\value{
inset layer

tree view with insets
}
\description{
gemo_inset can add subplots to tree by accepting a list of ggplot objects that are ancestral
stats or data associated with selected nodes in the tree. These ggplot objects can be any
kind of charts or hybrid of of these charts.

add subplots as insets in a tree
}
\details{
Users can also use
}
\references{
For demonstration of this function, please refer to chapter 8.3 of
\emph{Data Integration, Manipulation and Visualization of Phylogenetic Trees}
\url{http://yulab-smu.top/treedata-book/index.html} by Guangchuang Yu.
}
\author{
Guangchuang Yu
}
