% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_balance.R
\name{geom_balance}
\alias{geom_balance}
\title{geom_balance}
\usage{
geom_balance(
  node,
  fill = "steelblue",
  color = "white",
  alpha = 0.5,
  extend = 0,
  extendto = NULL
)
}
\arguments{
\item{node}{selected node (balance) to highlight its two direct descendant}

\item{fill}{color to fill in the highlight rectangle, default to "steelblue"}

\item{color}{color to outline highlight rectangle and divide balance, defaults to "white"}

\item{alpha}{alpha (transparency) for the highlight rectangle, defaults to 0.5}

\item{extend}{extend xmax of the highlight rectangle by the value of extend}

\item{extendto}{extend xmax of the highlight rectangle to the value of extendto}
}
\value{
ggplot2
}
\description{
highlights the two direct descendant clades of an internal node
}
\details{
Particularly useful when studying neighboring clades. Note that balances that
correspond to multichotomies will not be displayed.
}
\examples{
library(ggtree)
set.seed(123)
tr<- rtree(15)
x <- ggtree(tr)
x + geom_balance(17)

}
\references{
J. Silverman, et al. \emph{A phylogenetic transform enhances
analysis of compositional microbiota data}. (in preparation)

For more detailed demonstration, please refer to chapter 5.2.2 of
\emph{Data Integration, Manipulation and Visualization of Phylogenetic Trees}
\url{http://yulab-smu.top/treedata-book/index.html} by Guangchuang Yu.
}
\author{
Justin Silverman and modified by Guangchuang Yu
}
