% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gatom.R
\name{scoreGraph}
\alias{scoreGraph}
\title{Score metabolic graph}
\usage{
scoreGraph(
  g,
  k.gene,
  k.met,
  vertex.threshold.min = 0.1,
  edge.threshold.min = 0.1,
  met.score.coef = 1,
  show.warnings = TRUE,
  raw = FALSE
)
}
\arguments{
\item{g}{Metabolic graph obtained with makeMetabolic graph function}

\item{k.gene}{Number of gene signals to be scored positively, the higher is the number,
the larger will be the resulting module. If set to NULL, genes will not be used for scoring.}

\item{k.met}{Number of metabolite signals to be scored positively, the higher is the number,
the larger will be the resulting module. If set to NULL, metabolites will not be used for scoring.}

\item{vertex.threshold.min}{The worst acceptable estimated FDR for vertices.
If necessary number of positive metabolite signals will be decreased from `k.met` to reach this threshold.
Default value is 0.1.}

\item{edge.threshold.min}{The worst acceptable estimated FDR for vertices.
If necessary number of positive metabolite signals will be decreased from `k.gene` to reach this threshold.
Default value is 0.1.}

\item{met.score.coef}{Coefficient on which all vertex weights are multiplied. Can be used to balance vertex and edge
weights. Default values is 1.}

\item{show.warnings}{whether to show warnings}

\item{raw}{whether to return raw scored graph, not a SGMWCS instance. Default to FALSE.}
}
\value{
SGMWCS instance or scored igraph object
}
\description{
Score metabolic graph
}
\examples{
data("gEx")
gs <- scoreGraph(g = gEx, k.gene = 25, k.met = 25)

}
