% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pset_to_gdrDF.R
\name{getPSet}
\alias{getPSet}
\title{Get PharmacoSet}
\usage{
getPSet(
  pset_name,
  psetDir = getwd(),
  canonical = FALSE,
  timeout = 600,
  use_local_PSets_list = FALSE
)
}
\arguments{
\item{pset_name}{string with the name of the PharmacoSet}

\item{psetDir}{string with the temporary directory for the PharmacoSet}

\item{canonical}{logical flag indicating if the PSet canonical}

\item{timeout}{maximum number of seconds allowed for PSet download}

\item{use_local_PSets_list}{logical flag if PSets list should be used from
local. If FALSE PSets list will be taken from web.}
}
\value{
PharmacoSet object
}
\description{
Get PharmacoSet
}
\examples{
 
suppressMessages(getPSet(
  "Tavor_2020", 
  psetDir = system.file("extdata/pset", package = "gDRimport"),
  use_local_PSets_list = TRUE
))

}
\keyword{pset_conversion}
