/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.tree;

import com.gkano.bioinfo.javautils.JRITools_JavaUtils;
import com.gkano.bioinfo.tree.Clade;
import com.gkano.bioinfo.var.GeneralTools;
import com.gkano.bioinfo.var.Logger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.tree.TreeNode;

public class HierarchicalCluster {
    public static final String AVERAGE = "Average";
    public static final String COMPLETE = "Complete";
    public static final String SINGLE = "Single";
    public static final String[] LINKAGE_METHODS = new String[]{"Average", "Complete", "Single"};
    private double[][] distanceMatrix;
    private int linkageMethod;
    private String[] leafLabels;
    private int[] leafCount;
    private double[] joinDistance;
    private Clade[] nodes;
    private boolean verbose;

    public HierarchicalCluster() {
        this(null, null, COMPLETE, false);
    }

    public HierarchicalCluster(boolean verbose) {
        this(null, null, COMPLETE, verbose);
    }

    public HierarchicalCluster(double[][] distanceMatrix, String[] labels, boolean verbose) {
        this(distanceMatrix, labels, COMPLETE, verbose);
    }

    public HierarchicalCluster(double[][] distanceMatrix, String[] labels, String linkageMethod, boolean verbose) {
        this.setDistanceMatrix(distanceMatrix);
        this.setLeafLabels(labels);
        this.setLinkageMethod(linkageMethod);
        this.verbose = verbose;
        Logger.setVerbose(verbose);
    }

    public Clade cluster() {
        this.init();
        int rootIndex = -1;
        for (int i = 0; i < this.distanceMatrix.length - 1; ++i) {
            rootIndex = this.iterate();
        }
        Clade root = this.nodes[rootIndex];
        this.restore(this.distanceMatrix);
        return root;
    }

    public void similarityToDistance() {
        for (double[] distanceMatrix1 : this.distanceMatrix) {
            for (int j = 0; j < this.distanceMatrix[0].length; ++j) {
                distanceMatrix1[j] = 1.0 - distanceMatrix1[j];
            }
        }
    }

    private void init() {
        this.leafCount = new int[this.distanceMatrix.length];
        this.joinDistance = new double[this.distanceMatrix.length];
        this.nodes = new Clade[this.distanceMatrix.length];
        for (int i = 0; i < this.distanceMatrix.length; ++i) {
            this.joinDistance[i] = 0.0;
            this.leafCount[i] = 1;
            this.nodes[i] = new Clade(this.leafLabels[i], 0.0);
        }
    }

    private double newDistance(int oneJoin, int twoJoin, int fixrow) {
        double newD = -1111.0;
        switch (this.linkageMethod) {
            case 0: {
                int oneN = this.leafCount[oneJoin];
                int twoN = this.leafCount[twoJoin];
                newD = (this.distanceMatrix[Math.max(oneJoin, fixrow)][Math.min(oneJoin, fixrow)] * (double)oneN + this.distanceMatrix[Math.max(twoJoin, fixrow)][Math.min(twoJoin, fixrow)] * (double)twoN) / (double)(oneN + twoN);
                break;
            }
            case 1: {
                newD = Math.max(this.distanceMatrix[Math.max(oneJoin, fixrow)][Math.min(oneJoin, fixrow)], this.distanceMatrix[Math.max(twoJoin, fixrow)][Math.min(twoJoin, fixrow)]);
                break;
            }
            case 2: {
                newD = Math.min(this.distanceMatrix[Math.max(oneJoin, fixrow)][Math.min(oneJoin, fixrow)], this.distanceMatrix[Math.max(twoJoin, fixrow)][Math.min(twoJoin, fixrow)]);
            }
        }
        return newD;
    }

    private int iterate() {
        int i;
        int two = -1;
        int one = -1;
        double currentCloseness = Double.MAX_VALUE;
        for (i = 1; i < this.distanceMatrix.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!(this.distanceMatrix[i][j] >= 0.0) || !(this.distanceMatrix[i][j] < currentCloseness)) continue;
                currentCloseness = this.distanceMatrix[i][j];
                one = i;
                two = j;
            }
        }
        if (this.leafCount[one] > this.leafCount[two]) {
            i = two;
            two = one;
            one = i;
        }
        for (i = 0; i < this.distanceMatrix.length; ++i) {
            double newDistance;
            if (one == i || two == i) continue;
            this.distanceMatrix[Math.max((int)two, (int)i)][Math.min((int)two, (int)i)] = newDistance = this.newDistance(one, two, i);
        }
        for (i = 0; i < this.distanceMatrix.length; ++i) {
            if (i == one) continue;
            this.distanceMatrix[Math.max((int)one, (int)i)][Math.min((int)one, (int)i)] = -9999.0;
        }
        this.nodes[one].setBranchLength(currentCloseness - this.joinDistance[one]);
        this.nodes[two].setBranchLength(currentCloseness - this.joinDistance[two]);
        Clade joinedNode = new Clade();
        joinedNode.add(this.nodes[two]);
        joinedNode.add(this.nodes[one]);
        this.nodes[two] = joinedNode;
        this.nodes[one] = null;
        this.mergeMembers(this.leafCount, two, one);
        this.joinDistance[two] = currentCloseness;
        return two;
    }

    private void mergeMembers(int[] numMember, int joinedNodeIndex, int oldNodeIndex) {
        int n = joinedNodeIndex;
        numMember[n] = numMember[n] + numMember[oldNodeIndex];
    }

    private void restore(double[][] distanceMatrix) {
        for (int i = 1; i < distanceMatrix.length; ++i) {
            for (int j = 0; j < i; ++j) {
                distanceMatrix[i][j] = distanceMatrix[j][i];
            }
        }
    }

    public double[][] getDistanceMatrix() {
        return this.distanceMatrix;
    }

    public double[][] getReorderedMatrix(Clade root) {
        return this.getReorderedMatrix(this.getReorderedLabels(root));
    }

    public double[][] getReorderedMatrix(String[] reorderedLabels) {
        int[] indexes = new int[this.leafLabels.length];
        block0: for (int i = 0; i < reorderedLabels.length; ++i) {
            for (int j = 0; j < reorderedLabels.length; ++j) {
                if (!(reorderedLabels[i] == null ? this.leafLabels[j] == null : reorderedLabels[i].equals(this.leafLabels[j]))) continue;
                indexes[i] = j;
                continue block0;
            }
        }
        double[][] d = new double[this.distanceMatrix.length][this.distanceMatrix.length];
        for (int i = 0; i < d.length; ++i) {
            for (int j = 0; j < d.length; ++j) {
                d[i][j] = this.distanceMatrix[indexes[i]][indexes[j]];
            }
        }
        return d;
    }

    public String[] getReorderedLabels(Clade root) {
        String[] labels = new String[this.leafLabels.length];
        int k = 0;
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            Clade node = (Clade)e.nextElement();
            if (!node.isLeaf() || node.getUserObject() == null) continue;
            labels[k++] = node.toString();
        }
        return labels;
    }

    public final void setDistanceMatrix(double[][] distanceMatrix) {
        if (distanceMatrix != null && distanceMatrix.length != distanceMatrix[0].length) {
            throw new IllegalArgumentException("Distance matrix must be square");
        }
        this.distanceMatrix = distanceMatrix;
    }

    public String[] getLeafLabels() {
        return this.leafLabels;
    }

    public final void setLeafLabels(String[] labels) {
        this.leafLabels = labels;
    }

    public String getLinkageMethod() {
        return LINKAGE_METHODS[this.linkageMethod];
    }

    public final void setLinkageMethod(String linkageMethod) {
        this.linkageMethod = -1;
        for (int i = 0; i < LINKAGE_METHODS.length; ++i) {
            if (!LINKAGE_METHODS[i].equals(linkageMethod)) continue;
            this.linkageMethod = i;
            return;
        }
        if (this.linkageMethod == -1) {
            throw new IllegalArgumentException("Invalid linkage method: " + linkageMethod);
        }
    }

    public TreeMap<Integer, TreeSet<String>> hclusteringClusters(String[] sampleNames, double[][] distances, Integer minClusterSize, Double cutHeight, boolean extra, PrintStream ops) {
        try {
            ops = ops == null ? System.err : ops;
            String treeString = (String)this.hclusteringTree(sampleNames, distances, ops)[0];
            String[] labelsReordered = GeneralTools.reorderLabels(sampleNames, treeString);
            double[][] distancesReordered = GeneralTools.reorderDistances(distances, sampleNames, labelsReordered);
            ops.println("preJRI");
            JRITools_JavaUtils jritools = JRITools_JavaUtils.getInstance(null);
            ops.println("precut");
            TreeMap<Integer, TreeSet<String>> clusters = jritools.dynamicTreeCut(treeString, distancesReordered, labelsReordered, minClusterSize, cutHeight, extra);
            ops.println("afterCut");
            jritools.shutdown();
            ops.println(Logger.timestamp() + " Clusters=" + clusters.size() + "\n");
            for (Map.Entry<Integer, TreeSet<String>> entry : clusters.entrySet()) {
                int clusterId = entry.getKey();
                TreeSet<String> cluster = entry.getValue();
                for (String name : cluster) {
                    ops.println(name + "\t" + clusterId + "\t" + cluster.size());
                }
            }
            ops.println("\n\n");
            ops.flush();
            return clusters;
        }
        catch (Exception e) {
            Logger.error(this, e.getMessage());
            return null;
        }
    }

    public String[] hclusteringClustersNoJRI(TreeMap<Integer, TreeSet<String>> clusters) {
        return this.hclusteringClustersNoJRI(clusters, null);
    }

    public String[] hclusteringClustersNoJRI(TreeMap<Integer, TreeSet<String>> clusters, PrintStream ops) {
        try {
            ops = ops == null ? System.err : ops;
            ArrayList<String> al = new ArrayList<String>();
            ops.println(Logger.timestamp() + " Clusters=" + clusters.size() + "\n");
            for (Map.Entry<Integer, TreeSet<String>> entry : clusters.entrySet()) {
                StringBuilder sb = new StringBuilder();
                int clusterId = entry.getKey();
                sb.append(clusterId);
                TreeSet<String> cluster = entry.getValue();
                sb.append(" ").append(cluster.size());
                for (String name : cluster) {
                    ops.println(name + "\t" + clusterId + "\t" + cluster.size());
                    sb.append(" ").append(name);
                }
                al.add(sb.toString());
            }
            ops.println("\n\n");
            ops.flush();
            String[] ret = new String[al.size()];
            ret = al.toArray(ret);
            return ret;
        }
        catch (Exception e) {
            Logger.error(this, e.getMessage());
            return null;
        }
    }

    public TreeMap<Integer, TreeSet<String>> findClusters(double[] result, String[] labels) {
        try {
            TreeMap<Integer, TreeSet<String>> clusters = new TreeMap<Integer, TreeSet<String>>();
            for (int i = 0; i < result.length; ++i) {
                int clusterId = (int)result[i];
                TreeSet<String> cluster = clusters.get(clusterId);
                if (cluster == null) {
                    cluster = new TreeSet();
                    clusters.put(clusterId, cluster);
                }
                String label = labels[i];
                cluster.add(label);
            }
            return clusters;
        }
        catch (Exception e) {
            Logger.error(this, e.getMessage());
            return null;
        }
    }

    public TreeMap<Integer, TreeSet<String>> findClusters(int[] result, String[] labels) {
        return this.findClusters(Arrays.stream(result).asDoubleStream().toArray(), labels);
    }

    public Object[] hclusteringTree(String[] sampleNames, double[][] distances) {
        return this.hclusteringTree(sampleNames, distances, null);
    }

    public Object[] hclusteringTree(String[] sampleNames, float[][] distances, PrintStream ops) {
        int rows = distances.length;
        int cols = distances[0].length;
        double[][] output = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                output[i][j] = distances[i][j];
            }
        }
        return this.hclusteringTree(sampleNames, output, ops);
    }

    public Object[] hclusteringTree(String[] sampleNames, double[][] distances, PrintStream ops) {
        try {
            ops = ops == null ? System.err : ops;
            ops.println(Logger.timestamp() + " Distances=" + distances.length + "x" + distances[0].length);
            String method = COMPLETE;
            this.setDistanceMatrix(distances);
            this.setLeafLabels(sampleNames);
            this.setLinkageMethod(method);
            ops.println("hierarchical method=" + method);
            ops.flush();
            Clade root = this.cluster();
            String treeString = Clade.cladeToString(root).replace("\n", "");
            return new Object[]{treeString, root};
        }
        catch (Exception e) {
            Logger.error(this, e.getMessage());
            return null;
        }
    }
}

