/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.javautils;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.gkano.bioinfo.tree.Clade;
import com.gkano.bioinfo.tree.HierarchicalCluster;
import com.gkano.bioinfo.var.GeneralTools;
import com.gkano.bioinfo.var.Logger;
import com.gkano.bioinfo.vcf.SNPEncoder;
import com.gkano.bioinfo.vcf.VCFManager;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Parameters(commandDescription="VCF2TREE")
public class UtilVCF2TREE {
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(names={"-v", "--verbose"})
    private boolean verbose = false;
    @Parameter(description="<positional input files>")
    private List<String> positionalInputFiles = new ArrayList<String>();
    @Parameter(names={"-i", "--input"}, description="VCF input file(s)", variableArity=true)
    private List<String> namedInputFiles = new ArrayList<String>();
    @Parameter(names={"-o", "--output"}, description="Tree output file")
    private String outputFile;
    @Parameter(names={"--numberOfThreads", "-t"})
    private int numOfThreads = 1;
    @Parameter(names={"--bootstrap", "-b"}, description="Number of bootstrap replicates")
    private int numBootstraps = 0;

    public static String getUtilName() {
        return "VCF2TREE";
    }

    public void go() {
        try (PrintStream ops = GeneralTools.getPrintStreamOrExit(this.outputFile, this);){
            VCFManager<String> vcfm = new VCFManager<String>(Stream.concat(this.positionalInputFiles.stream(), this.namedInputFiles.stream()).collect(Collectors.toList()), this.numOfThreads, SNPEncoder.StringToStringParser, this.verbose);
            try {
                Field bsField = vcfm.getClass().getDeclaredField("numBootstraps");
                bsField.setAccessible(true);
                bsField.setInt(vcfm, this.numBootstraps);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                Logger.error(this, "Could not set numBootstraps in VCFManager: " + e.getMessage());
            }
            vcfm.init();
            new Thread(vcfm).start();
            vcfm.awaitFinalization();
            List<String> sampleNames = vcfm.getSampleNames();
            if (this.numBootstraps > 0) {
                List<float[][]> allDistances = vcfm.reduceDotProdToDistancesBootstraps();
                HierarchicalCluster hc = new HierarchicalCluster(this.verbose);
                Object[] originalTreeAndRoot = hc.hclusteringTree((String[])sampleNames.toArray(String[]::new), allDistances.get(0), (PrintStream)null);
                String originalTree = (String)originalTreeAndRoot[0];
                Clade originalRoot = (Clade)originalTreeAndRoot[1];
                ArrayList<Clade> bootstrapTrees = new ArrayList<Clade>();
                for (int b = 1; b < allDistances.size(); ++b) {
                    Object[] bootTreeAndRoot = hc.hclusteringTree((String[])sampleNames.toArray(String[]::new), allDistances.get(b), (PrintStream)null);
                    String bootTree = (String)bootTreeAndRoot[0];
                    Clade bootRoot = (Clade)bootTreeAndRoot[1];
                    bootstrapTrees.add(bootRoot);
                }
                Clade.annotateTreeWithBootstrap(originalRoot, bootstrapTrees, sampleNames.size(), this.numBootstraps);
                ops.println(Clade.cladeToString(originalRoot));
            } else {
                float[][] distances = vcfm.reduceDotProdToDistances();
                HierarchicalCluster hc = new HierarchicalCluster(this.verbose);
                String treeString = (String)hc.hclusteringTree((String[])sampleNames.toArray(String[]::new), distances, (PrintStream)null)[0];
                ops.println(treeString);
            }
            ops.close();
        }
        catch (InterruptedException e) {
            Logger.error(this, e.getMessage());
            System.exit(1);
        }
    }
}

