% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProfileHeatmap.R
\name{.makeFinalProfileHeatmap}
\alias{.makeFinalProfileHeatmap}
\title{Make a profile heatmap}
\usage{
.makeFinalProfileHeatmap(
  data,
  x = NULL,
  y = NULL,
  fill = NULL,
  colour = NULL,
  linetype = NULL,
  facet_x = NULL,
  facet_y = NULL,
  summary_fun = c("mean", "median", "min", "max", "none"),
  rel_height = 0.3,
  x_lab = NULL,
  y_lab = NULL,
  fill_lab = NULL,
  lab_fun_x = waiver(),
  label_side = c("left", "right", "none"),
  ...
)
}
\arguments{
\item{data}{A data.frame or tibble in long form}

\item{x, y}{The values mapped to the x & y axes}

\item{fill}{The column used for heatmap colours}

\item{colour, linetype}{Columns used for the summary plot in the top panel}

\item{facet_x, facet_y}{Columns used to facet the plot along these axes}

\item{summary_fun}{Function used to create the summary value at each position}

\item{rel_height}{The relative height of the top panel}

\item{x_lab, y_lab, fill_lab}{_labels added to x/y-axes & the fill legend}

\item{...}{Passed to facet_grid}
}
\value{
A ggplot2 object
}
\description{
Make a profile heatmap with optional summary panel at the top
}
\details{
The workhorse function for generating the final heatmap
Expects a single data.frame in long form with requisite columns
}
\keyword{internal}
