% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif.R
\name{addMotifScore}
\alias{addMotifScore}
\title{Add Motif Scores}
\usage{
addMotifScore(
  regulon,
  field_name = "motif",
  peaks = NULL,
  pwms = NULL,
  species = c("human", "mouse"),
  genome = c("hg38", "hg19", "mm10"),
  ...
)
}
\arguments{
\item{regulon}{A DataFrame consisting of tf (regulator) and target in the column names.}

\item{field_name}{Character string    indicating the column name of the regulon to add the motif information to}

\item{peaks}{A GRanges object indicating the peaks to perform motif annotation on if ArchR project is not provided.
The peak indices should match the \code{re} column in the regulon}

\item{pwms}{A PWMatrixList for annotation of motifs using 'motifmatchr::matchMotifs'}

\item{species}{Character string indicating species. Currently supported species is human or mouse}

\item{genome}{Character string indicating the genomic build}

\item{...}{Additional arguments to pass into motifmatchr::matchMotifs}
}
\value{
A DataFrame with motif matches added with 1s indicating the presence of motifs and
0s indicating the absence of motifs
}
\description{
Add Motif Scores
}
\examples{
regulon <- S4Vectors::DataFrame(tf = c('AR','AR','AR','ESR1','ESR1','NKX2-1'),
idxATAC = 1:6)
peaks <- GenomicRanges::GRanges(seqnames = c('chr12','chr19','chr19','chr11','chr6','chr1'),
ranges = IRanges::IRanges(start = c(124914563,50850845, 50850844, 101034172, 151616327, 1000),
end = c(124914662,50850929, 50850929, 101034277, 151616394,2000)))
regulon <- addMotifScore(regulon, peaks=peaks)
}
