% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsEmapInternal.R
\encoding{UTF-8}
\name{createBasicEmapAsIgraph}
\alias{createBasicEmapAsIgraph}
\title{Create a basic enrichment map}
\usage{
createBasicEmapAsIgraph(
  gostResults,
  backgroundGenes,
  showCategory,
  similarityCutOff
)
}
\arguments{
\item{gostResults}{a \code{data.frame} containing the enrichment 
results to be plot.}

\item{backgroundGenes}{a \code{vector} of \code{character} string 
representing the name of the genes present in the request.}

\item{showCategory}{a positive \code{integer} or a \code{vector} of 
\code{characters} representing terms.  If a \code{integer}, the first 
\code{n} terms will be displayed. If \code{vector} of terms, 
the selected terms will be displayed.}

\item{similarityCutOff}{a positive \code{numeric} between 0 and 1 indicating 
the minimum level of similarity between two terms to have an edge linking 
the terms.}
}
\value{
a \code{igraph} object representing the enrichment map.
}
\description{
The function creates a basic enrichment map using functional 
enrichment results.
}
\examples{

## Load the result of an enrichment analysis done with gprofiler2
data(parentalNapaVsDMSOEnrichment)

## Only retain the results section
gostResults <- as.data.frame(parentalNapaVsDMSOEnrichment$result)

## Limit the results to Wikipathways
## and remove the root term
gostResults <- gostResults[which(gostResults$source == "WP"),]
gostResults <- gostResults[which(gostResults$term_name != "WIKIPATHWAYS"),]

## Extract meta data information
meta <- parentalNapaVsDMSOEnrichment$meta

## Get all background genes
backgroundGenes <- meta$query_metadata$queries[["parental_napa_vs_DMSO"]]

## Create basic enrichment map, as an igraph, using Wikipathways terms
enrichViewNet:::createBasicEmapAsIgraph(gostResults=gostResults, 
    backgroundGenes=backgroundGenes, showCategory=30L, 
    similarityCutOff=0.2)
    
}
\author{
Astrid Deschênes
}
\keyword{internal}
