% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reads_simulator.R
\name{donor_read_simulator}
\alias{donor_read_simulator}
\title{Reads simulator for donor identification}
\usage{
donor_read_simulator(
  GT,
  D_seed,
  sample_variants = FALSE,
  donor_size = NULL,
  beta_shapes = NULL,
  n_cell = 5000,
  doublet_rate = NULL
)
}
\arguments{
\item{GT}{Variant-by-donor matrix for genotypes}

\item{D_seed}{Variant-by-cell matrix for read coverage for generating depth,
which be row sample and column sample both with replacement}

\item{sample_variants}{logical(1), if TRUE, sample variants with replacement
to the same size, otherwise not}

\item{donor_size}{Vector of float for the fractions of each donor; default
NULL means uniform}

\item{beta_shapes}{A 3-by-2 matrix of beta parameters for genotypes: 0, 1,
and 2; default NULL means matrix(c(0.2, 0.5, 99.8, 99.8, 0.5, 0.2), nrow = 3)}

\item{n_cell}{An integer for number of total cells}

\item{doublet_rate}{A float from 0 to 1 for doublet rate; default NULL means
rate n_cell / 100000}
}
\value{
A list of various components of the simulated dataset.
}
\description{
Reads simulator for donor identification
}
