% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cBioPortal-class.R
\docType{class}
\name{cBioPortal-class}
\alias{cBioPortal-class}
\alias{.cBioPortal}
\alias{operations,cBioPortal-method}
\title{A class for representing the cBioPortal API protocol}
\usage{
\S4method{operations}{cBioPortal}(x, ..., .deprecated = FALSE)
}
\arguments{
\item{x}{A \link[AnVIL:Services]{AnVIL} instance or API representation as
given by the \link{cBioPortal} function.}

\item{...}{additional arguments passed to methods or, for
\verb{operations,Service-method}, to the internal \code{get_operation()}
function.}

\item{.deprecated}{optional logical(1) include deprecated operations?}
}
\value{
A \code{cBioPortal} class instance
}
\description{
The \code{cBioPortal} class is a representation of the \code{cBioPortal}
API protocol that directly inherits from the \code{Service} class in the
\code{AnVIL} package. For more information, see the
\link[AnVIL:Services]{AnVIL} package.
}
\details{
This class takes the static API as provided at
\url{https://www.cbioportal.org/api/v2/api-docs} and creates an R object
with the help from underlying infrastructure (i.e.,
\link[rapiclient:rapiclient-package]{rapiclient} and
\link[AnVIL:Services]{AnVIL}) to give the user a unified representation
of the API specification provided by the cBioPortal group. Users are not
expected to interact with this class other than to use it as input
to the functionality provided by the rest of the package.
}
\section{Functions}{
\itemize{
\item \code{operations(cBioPortal)}: List all the \code{operations} available with the
cBioPortal API object, e.g., \code{api$operation}

}}
\examples{

cBioPortal()

}
\seealso{
\link{cBioPortal}, \link[AnVIL:Services]{AnVIL}
}
