% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedbaser.R
\name{bb_metadata}
\alias{bb_metadata}
\title{Get metadata for a BED file or BEDset}
\usage{
bb_metadata(bedbase, id, full = FALSE)
}
\arguments{
\item{bedbase}{BEDbase() object}

\item{id}{integer(1) record or object identifier}

\item{full}{logical(1) (default \code{FALSE}) include full record with
stats, files, and metadata}
}
\value{
list() metadata
}
\description{
Get metadata for a BED file or BEDset given its id. Abort if
not found or id is not not 32 characters.
}
\examples{
bedbase <- BEDbase()

ex_bed <- bb_example(bedbase, "bed")
bb_metadata(bedbase, ex_bed$id)

ex_bedset <- bb_example(bedbase, "bedset")
bb_metadata(bedbase, ex_bedset$id)

}
